/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.ConvertForLoopOperation;
import org.eclipse.jdt.internal.corext.fix.ConvertIterableLoopOperation;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class ConvertLoopFix
extends CompilationUnitRewriteOperationsFix {
    private final IStatus fStatus;

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean convertForLoops, boolean convertIterableForLoops, boolean makeFinal) {
        if (!JavaModelUtil.is50OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        if (!convertForLoops && !convertIterableForLoops) {
            return null;
        }
        ArrayList<ConvertLoopOperation> operations = new ArrayList<ConvertLoopOperation>();
        ControlStatementFinder finder = new ControlStatementFinder(convertForLoops, convertIterableForLoops, makeFinal, operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]);
        return new ConvertLoopFix(FixMessages.ControlStatementsFix_change_name, compilationUnit, ops, null);
    }

    public static ConvertLoopFix createConvertForLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement loop) {
        ConvertForLoopOperation convertForLoopOperation = new ConvertForLoopOperation(loop);
        if (!((ConvertLoopOperation)convertForLoopOperation).satisfiesPreconditions().isOK()) {
            return null;
        }
        return new ConvertLoopFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{convertForLoopOperation}, null);
    }

    public static ConvertLoopFix createConvertIterableLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement loop) {
        ConvertIterableLoopOperation loopConverter = new ConvertIterableLoopOperation(loop);
        IStatus status = loopConverter.satisfiesPreconditions();
        if (status.getSeverity() == 4) {
            return null;
        }
        return new ConvertLoopFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{loopConverter}, status);
    }

    protected ConvertLoopFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations, IStatus status) {
        super(name, compilationUnit, fixRewriteOperations);
        this.fStatus = status;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ControlStatementFinder
    extends GenericVisitor {
        private final List<ConvertLoopOperation> fResult;
        private final Hashtable<ForStatement, String> fUsedNames;
        private final boolean fFindForLoopsToConvert;
        private final boolean fConvertIterableForLoops;
        private final boolean fMakeFinal;

        public ControlStatementFinder(boolean findForLoopsToConvert, boolean convertIterableForLoops, boolean makeFinal, List<ConvertLoopOperation> resultingCollection) {
            this.fFindForLoopsToConvert = findForLoopsToConvert;
            this.fConvertIterableForLoops = convertIterableForLoops;
            this.fMakeFinal = makeFinal;
            this.fResult = resultingCollection;
            this.fUsedNames = new Hashtable();
        }

        @Override
        public boolean visit(ForStatement node) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                ForStatement current = node;
                ConvertLoopOperation operation = this.getConvertOperation(current);
                ConvertLoopOperation oldOperation = null;
                while (operation != null) {
                    if (oldOperation == null) {
                        this.fResult.add(operation);
                    } else {
                        oldOperation.setBodyConverter(operation);
                    }
                    if (current.getBody() instanceof ForStatement) {
                        current = (ForStatement)current.getBody();
                        oldOperation = operation;
                        operation = this.getConvertOperation(current);
                        continue;
                    }
                    operation = null;
                }
                current.getBody().accept((ASTVisitor)this);
                return false;
            }
            return super.visit(node);
        }

        private ConvertLoopOperation getConvertOperation(ForStatement node) {
            ConvertIterableLoopOperation iterableConverter;
            Collection<String> usedNamesCollection = this.fUsedNames.values();
            String[] usedNames = usedNamesCollection.toArray(new String[usedNamesCollection.size()]);
            ConvertForLoopOperation convertForLoopOperation = new ConvertForLoopOperation(node, usedNames, this.fMakeFinal);
            if (((ConvertLoopOperation)convertForLoopOperation).satisfiesPreconditions().isOK()) {
                if (this.fFindForLoopsToConvert) {
                    this.fUsedNames.put(node, ((ConvertLoopOperation)convertForLoopOperation).getIntroducedVariableName());
                    return convertForLoopOperation;
                }
            } else if (this.fConvertIterableForLoops && ((ConvertLoopOperation)(iterableConverter = new ConvertIterableLoopOperation(node, usedNames, this.fMakeFinal))).satisfiesPreconditions().isOK()) {
                this.fUsedNames.put(node, ((ConvertLoopOperation)iterableConverter).getIntroducedVariableName());
                return iterableConverter;
            }
            return null;
        }

        @Override
        public void endVisit(ForStatement node) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                this.fUsedNames.remove(node);
            }
            super.endVisit(node);
        }
    }
}

