/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.views;

import java.text.DecimalFormat;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.identifier.scan.IScanTargetCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.ux.extension.csd.ui.views.AbstractChromatogramSelectionCSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ScanIdentifiedListView
extends AbstractChromatogramSelectionCSDView {
    private Text targetsText;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    @Inject
    public ScanIdentifiedListView(Composite parent, MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.createControl(parent);
    }

    @Override
    public void update(IChromatogramSelectionCSD chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            StringBuilder builder = new StringBuilder();
            for (IScan scan : chromatogramSelection.getChromatogramCSD().getScans()) {
                IScanCSD scanCSD;
                int retentionTime;
                int startRetentionTime = chromatogramSelection.getStartRetentionTime();
                int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
                if (!(scan instanceof IScanCSD) || (retentionTime = scan.getRetentionTime()) < startRetentionTime || retentionTime > stopRetentionTime || (scanCSD = (IScanCSD)scan).getTargets().size() <= 0) continue;
                for (IScanTargetCSD scanTargetCSD : scanCSD.getTargets()) {
                    builder.append(scanTargetCSD.getLibraryInformation().getName());
                    builder.append(" > ");
                    builder.append(scanTargetCSD.getComparisonResult().getMatchFactor());
                    builder.append("% | ");
                    builder.append(this.decimalFormat.format((double)scanCSD.getRetentionTime() / 60000.0));
                    builder.append(" min");
                    builder.append(Text.DELIMITER);
                }
            }
            this.targetsText.setText(builder.toString());
        }
    }

    private void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.targetsText = new Text(parent, 834);
        this.targetsText.setText("");
        this.targetsText.setLayoutData((Object)new GridData(1808));
    }
}

