/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.selection;

import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.numeric.core.Point;

public abstract class AbstractChromatogramSelection
implements IChromatogramSelection {
    private IChromatogram chromatogram;
    private int startRetentionTime;
    private int stopRetentionTime;
    private float startAbundance;
    private float stopAbundance;
    private boolean overlaySelected;
    private boolean lockOffset;
    private Point offset;

    public AbstractChromatogramSelection(IChromatogram chromatogram) throws ChromatogramIsNullException {
        this(chromatogram, true);
    }

    public AbstractChromatogramSelection(IChromatogram chromatogram, boolean fireUpdate) throws ChromatogramIsNullException {
        if (chromatogram == null) {
            throw new ChromatogramIsNullException("The chromatogram must not be null.");
        }
        this.chromatogram = chromatogram;
        this.overlaySelected = true;
        this.lockOffset = false;
        this.offset = new Point(0.0, 0.0);
        this.chromatogram.addChromatogramUpdateListener(this);
    }

    public void dispose() {
        this.chromatogram = null;
    }

    @Override
    public IChromatogram getChromatogram() {
        return this.chromatogram;
    }

    @Override
    public int getStartRetentionTime() {
        return this.startRetentionTime;
    }

    @Override
    public void setStartRetentionTime(int startRetentionTime) {
        this.setStartRetentionTime(startRetentionTime, true);
    }

    private void setStartRetentionTime(int startRetentionTime, boolean update) {
        this.startRetentionTime = startRetentionTime > 0 && startRetentionTime <= this.stopRetentionTime ? startRetentionTime : this.chromatogram.getStartRetentionTime();
        if (update) {
            this.fireUpdateChange(false);
        }
    }

    @Override
    public int getStopRetentionTime() {
        return this.stopRetentionTime;
    }

    @Override
    public void setStopRetentionTime(int stopRetentionTime) {
        this.setStopRetentionTime(stopRetentionTime, true);
    }

    private void setStopRetentionTime(int stopRetentionTime, boolean update) {
        this.stopRetentionTime = stopRetentionTime > 0 && stopRetentionTime >= this.startRetentionTime && stopRetentionTime <= this.chromatogram.getStopRetentionTime() ? stopRetentionTime : this.chromatogram.getStopRetentionTime();
        if (update) {
            this.fireUpdateChange(false);
        }
    }

    @Override
    public float getStartAbundance() {
        return this.startAbundance;
    }

    @Override
    public void setStartAbundance(float startAbundance) {
        this.setStartAbundance(startAbundance, true);
    }

    private void setStartAbundance(float startAbundance, boolean update) {
        this.startAbundance = startAbundance >= 0.0f && startAbundance <= this.stopAbundance && !Float.isInfinite(startAbundance) && !Float.isNaN(startAbundance) ? startAbundance : 0.0f;
        if (update) {
            this.fireUpdateChange(false);
        }
    }

    @Override
    public float getStopAbundance() {
        return this.stopAbundance;
    }

    @Override
    public void setStopAbundance(float stopAbundance) {
        this.setStopAbundance(stopAbundance, true);
    }

    private void setStopAbundance(float stopAbundance, boolean update) {
        this.stopAbundance = stopAbundance >= 0.0f && stopAbundance >= this.startAbundance && !Float.isInfinite(stopAbundance) && !Float.isNaN(stopAbundance) ? stopAbundance : this.chromatogram.getMaxSignal();
        if (update) {
            this.fireUpdateChange(false);
        }
    }

    @Override
    public void reset(boolean fireUpdate) {
        this.startRetentionTime = this.chromatogram.getStartRetentionTime();
        this.stopRetentionTime = this.chromatogram.getStopRetentionTime();
        this.startAbundance = 0.0f;
        this.stopAbundance = this.chromatogram.getMaxSignal();
    }

    @Override
    public void setRanges(int startRetentionTime, int stopRetentionTime, float startAbundance, float stopAbundance) {
        this.startRetentionTime = startRetentionTime;
        this.stopRetentionTime = stopRetentionTime;
        this.startAbundance = startAbundance;
        this.stopAbundance = stopAbundance;
        this.setStartRetentionTime(startRetentionTime, false);
        this.setStopRetentionTime(stopRetentionTime, false);
        this.setStartAbundance(startAbundance, false);
        this.setStopAbundance(stopAbundance, false);
        this.update(false);
    }

    @Override
    public void update(boolean forceReload) {
        this.setStopAbundance(this.stopAbundance, false);
        this.setStartAbundance(this.startAbundance, false);
        this.setStartAbundance(this.startAbundance, false);
        this.setStopAbundance(this.stopAbundance, false);
    }

    @Override
    public boolean isOverlaySelected() {
        return this.overlaySelected;
    }

    @Override
    public void setOverlaySelected(boolean overlaySelected) {
        this.overlaySelected = overlaySelected;
    }

    @Override
    public boolean isLockOffset() {
        return this.lockOffset;
    }

    @Override
    public void setLockOffset(boolean lockOffset) {
        this.lockOffset = lockOffset;
    }

    @Override
    public Point getOffset() {
        return this.offset;
    }

    @Override
    public void resetOffset() {
        this.offset.setX(0.0);
        this.offset.setY(0.0);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractChromatogramSelection other = (AbstractChromatogramSelection)otherObject;
        return this.getChromatogram() == other.getChromatogram() && this.getStartRetentionTime() == other.getStartRetentionTime() && this.getStopRetentionTime() == other.getStopRetentionTime();
    }

    public int hashCode() {
        return 7 * this.getChromatogram().hashCode() + 11 * Integer.valueOf(this.getStartRetentionTime()).hashCode() + 13 * Integer.valueOf(this.getStopRetentionTime()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("chromatogram=" + this.chromatogram);
        builder.append(",");
        builder.append("startRetentionTime=" + this.startRetentionTime);
        builder.append(",");
        builder.append("stopRetentionTime=" + this.stopRetentionTime);
        builder.append("]");
        return builder.toString();
    }
}

