/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.NormOps;

public class SpecializedOps {
    public static DenseMatrix64F createReflector(RowD1Matrix64F u) {
        if (!MatrixFeatures.isVector(u)) {
            throw new IllegalArgumentException("u must be a vector");
        }
        double norm = NormOps.fastNormF(u);
        double gamma = -2.0 / (norm * norm);
        DenseMatrix64F Q = CommonOps.identity(u.getNumElements());
        CommonOps.multAddTransB(gamma, u, u, Q);
        return Q;
    }

    public static DenseMatrix64F createReflector(DenseMatrix64F u, double gamma) {
        if (!MatrixFeatures.isVector(u)) {
            throw new IllegalArgumentException("u must be a vector");
        }
        DenseMatrix64F Q = CommonOps.identity(u.getNumElements());
        CommonOps.multAddTransB(-gamma, u, u, Q);
        return Q;
    }

    public static DenseMatrix64F copyChangeRow(int[] order, DenseMatrix64F src, DenseMatrix64F dst) {
        if (dst == null) {
            dst = new DenseMatrix64F(src.numRows, src.numCols);
        } else if (src.numRows != dst.numRows || src.numCols != dst.numCols) {
            throw new IllegalArgumentException("src and dst must have the same dimensions.");
        }
        int i = 0;
        while (i < src.numRows) {
            int indexDst = i * src.numCols;
            int indexSrc = order[i] * src.numCols;
            System.arraycopy(src.data, indexSrc, dst.data, indexDst, src.numCols);
            ++i;
        }
        return dst;
    }

    public static DenseMatrix64F copyTriangle(DenseMatrix64F src, DenseMatrix64F dst, boolean upper) {
        if (dst == null) {
            dst = new DenseMatrix64F(src.numRows, src.numCols);
        } else if (src.numRows != dst.numRows || src.numCols != dst.numCols) {
            throw new IllegalArgumentException("src and dst must have the same dimensions.");
        }
        if (upper) {
            int N = Math.min(src.numRows, src.numCols);
            int i = 0;
            while (i < N) {
                int index = i * src.numCols + i;
                System.arraycopy(src.data, index, dst.data, index, src.numCols - i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < src.numRows) {
                int length = Math.min(i + 1, src.numCols);
                int index = i * src.numCols;
                System.arraycopy(src.data, index, dst.data, index, length);
                ++i;
            }
        }
        return dst;
    }

    public static double diffNormF(D1Matrix64F a, D1Matrix64F b) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            throw new IllegalArgumentException("Both matrices must have the same shape.");
        }
        int size = a.getNumElements();
        DenseMatrix64F diff = new DenseMatrix64F(size, 1);
        int i = 0;
        while (i < size) {
            diff.set(i, b.get(i) - a.get(i));
            ++i;
        }
        return NormOps.normF(diff);
    }

    public static double diffNormF_fast(D1Matrix64F a, D1Matrix64F b) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            throw new IllegalArgumentException("Both matrices must have the same shape.");
        }
        int size = a.getNumElements();
        double total = 0.0;
        int i = 0;
        while (i < size) {
            double diff = b.get(i) - a.get(i);
            total += diff * diff;
            ++i;
        }
        return Math.sqrt(total);
    }

    public static double diffNormP1(D1Matrix64F a, D1Matrix64F b) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            throw new IllegalArgumentException("Both matrices must have the same shape.");
        }
        int size = a.getNumElements();
        double total = 0.0;
        int i = 0;
        while (i < size) {
            total += Math.abs(b.get(i) - a.get(i));
            ++i;
        }
        return total;
    }

    public static void addIdentity(RowD1Matrix64F A, RowD1Matrix64F B, double alpha) {
        if (A.numCols != A.numRows) {
            throw new IllegalArgumentException("A must be square");
        }
        if (B.numCols != A.numCols || B.numRows != A.numRows) {
            throw new IllegalArgumentException("B must be the same shape as A");
        }
        int n = A.numCols;
        int index = 0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (i == j) {
                    B.set(index, A.get(index) + alpha);
                } else {
                    B.set(index, A.get(index));
                }
                ++j;
                ++index;
            }
            ++i;
        }
    }

    public static void subvector(RowD1Matrix64F A, int rowA, int colA, int length, boolean row, int offsetV, RowD1Matrix64F v) {
        if (row) {
            int i = 0;
            while (i < length) {
                v.set(offsetV + i, A.get(rowA, colA + i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                v.set(offsetV + i, A.get(rowA + i, colA));
                ++i;
            }
        }
    }

    public static DenseMatrix64F[] splitIntoVectors(RowD1Matrix64F A, boolean column) {
        int w = column ? A.numCols : A.numRows;
        int M = column ? A.numRows : 1;
        int N = column ? 1 : A.numCols;
        int o = Math.max(M, N);
        DenseMatrix64F[] ret = new DenseMatrix64F[w];
        int i = 0;
        while (i < w) {
            DenseMatrix64F a = new DenseMatrix64F(M, N);
            if (column) {
                SpecializedOps.subvector(A, 0, i, o, false, 0, a);
            } else {
                SpecializedOps.subvector(A, i, 0, o, true, 0, a);
            }
            ret[i] = a;
            ++i;
        }
        return ret;
    }

    public static DenseMatrix64F pivotMatrix(DenseMatrix64F ret, int[] pivots, int numPivots, boolean transposed) {
        if (ret == null) {
            ret = new DenseMatrix64F(numPivots, numPivots);
        } else {
            if (ret.numCols != numPivots || ret.numRows != numPivots) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CommonOps.fill(ret, 0.0);
        }
        if (transposed) {
            int i = 0;
            while (i < numPivots) {
                ret.set(pivots[i], i, 1.0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numPivots) {
                ret.set(i, pivots[i], 1.0);
                ++i;
            }
        }
        return ret;
    }

    public static double diagProd(RowD1Matrix64F T) {
        double prod = 1.0;
        int N = Math.min(T.numRows, T.numCols);
        int i = 0;
        while (i < N) {
            prod *= T.unsafe_get(i, i);
            ++i;
        }
        return prod;
    }

    public static double elementDiagonalMaxAbs(D1Matrix64F a) {
        int size = Math.min(a.numRows, a.numCols);
        double max = 0.0;
        int i = 0;
        while (i < size) {
            double val = Math.abs(a.get(i, i));
            if (val > max) {
                max = val;
            }
            ++i;
        }
        return max;
    }

    public static double qualityTriangular(D1Matrix64F T) {
        int N = Math.min(T.numRows, T.numCols);
        double max = SpecializedOps.elementDiagonalMaxAbs(T);
        if (max == 0.0) {
            return 0.0;
        }
        double quality = 1.0;
        int i = 0;
        while (i < N) {
            quality *= T.unsafe_get(i, i) / max;
            ++i;
        }
        return Math.abs(quality);
    }

    public static double elementSumSq(D1Matrix64F m) {
        double total = 0.0;
        int N = m.getNumElements();
        int i = 0;
        while (i < N) {
            double d = m.data[i];
            total += d * d;
            ++i;
        }
        return total;
    }
}

