/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.alg.dense.decompose.lu.LUDecompositionBase_CD64;
import org.ejml.data.CDenseMatrix64F;

public class LUDecompositionNR_CD64
extends LUDecompositionBase_CD64 {
    private static final double TINY = 1.0E-40;

    @Override
    public boolean decompose(CDenseMatrix64F orig) {
        this.decomposeCommonInit(orig);
        int i = 0;
        while (i < this.m) {
            double big = 0.0;
            double bigReal = 0.0;
            double bigImg = 0.0;
            int j = 0;
            while (j < this.n) {
                double real = this.dataLU[i * this.stride + j * 2];
                double img = this.dataLU[i * this.stride + j * 2 + 1];
                double temp = real * real + img * img;
                if (big < temp) {
                    big = temp;
                    bigReal = real;
                    bigImg = img;
                }
                ++j;
            }
            if (big == 0.0) {
                bigReal = 1.0;
                bigImg = 0.0;
            }
            this.vv[i * 2] = bigReal / (big * big);
            this.vv[i * 2 + 1] = -bigImg / (big * big);
            ++i;
        }
        int k = 0;
        while (k < this.n) {
            int imax = -1;
            double big = 0.0;
            int i2 = k;
            while (i2 < this.m) {
                double luReal = this.dataLU[i2 * this.stride + k * 2];
                double vvReal = this.vv[i2 * 2];
                double luImg = this.dataLU[i2 * this.stride + k * 2 + 1];
                double vvImg = this.vv[i2 * 2 + 1];
                double tmpReal = luReal * vvReal - luImg * vvImg;
                double tmpImg = luImg * vvReal + luReal * vvReal;
                double tmpMag = tmpReal * tmpReal + tmpImg * tmpImg;
                if (tmpMag > big) {
                    big = tmpMag;
                    imax = i2;
                }
                ++i2;
            }
            if (imax < 0) {
                this.indx[k] = -1;
                return true;
            }
            if (k != imax) {
                int imax_n = imax * this.stride;
                int k_n = k * this.stride;
                int end = k_n + this.n * 2;
                while (k_n < end) {
                    double tempReal = this.dataLU[imax_n];
                    double tempImg = this.dataLU[imax_n + 1];
                    this.dataLU[imax_n] = this.dataLU[k_n];
                    this.dataLU[imax_n + 1] = this.dataLU[k_n + 1];
                    this.dataLU[k_n] = tempReal;
                    this.dataLU[k_n + 1] = tempImg;
                    imax_n += 2;
                    k_n += 2;
                }
                this.pivsign = -this.pivsign;
                this.vv[imax * 2] = this.vv[k * 2];
                this.vv[imax * 2 + 1] = this.vv[k * 2 + 1];
                int z = this.pivot[imax];
                this.pivot[imax] = this.pivot[k];
                this.pivot[k] = z;
            }
            this.indx[k] = imax;
            double element_kk_real = this.dataLU[k * this.stride + k * 2];
            double element_kk_img = this.dataLU[k * this.stride + k * 2 + 1];
            double mag = element_kk_real * element_kk_real + element_kk_img * element_kk_img;
            if (mag == 0.0) {
                element_kk_real = 1.0E-40;
                this.dataLU[k * this.stride + k * 2] = 1.0E-40;
                element_kk_img = 0.0;
                this.dataLU[k * this.stride + k * 2 + 1] = 0.0;
            }
            double element_kk_norm2 = element_kk_real * element_kk_real + element_kk_img * element_kk_img;
            int i3 = k + 1;
            while (i3 < this.m) {
                int i_n = i3 * this.stride;
                double luReal = this.dataLU[i_n + k * 2];
                double luImg = this.dataLU[i_n + k * 2 + 1];
                double tmpReal = (luReal * element_kk_real + luImg * element_kk_img) / element_kk_norm2;
                double tmpImg = (luImg * element_kk_real - luReal * element_kk_img) / element_kk_norm2;
                this.dataLU[i_n + k * 2] = tmpReal;
                this.dataLU[i_n + k * 2 + 1] = tmpImg;
                int k_n = k * this.stride + k * 2 + 2;
                int end = i_n + this.n * 2;
                i_n += k * 2 + 2;
                while (i_n < end) {
                    luReal = this.dataLU[k_n];
                    luImg = this.dataLU[k_n + 1];
                    int n = i_n;
                    this.dataLU[n] = this.dataLU[n] - (tmpReal * luReal - tmpImg * luImg);
                    int n2 = i_n + 1;
                    this.dataLU[n2] = this.dataLU[n2] - (tmpReal * luImg + tmpImg * luReal);
                    k_n += 2;
                    i_n += 2;
                }
                ++i3;
            }
            ++k;
        }
        return true;
    }
}

