/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.xic;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.comparator.IonValueComparator;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IIonRange;
import org.eclipse.chemclipse.msd.model.xic.IonRange;
import org.eclipse.chemclipse.numeric.statistics.Calculations;

public class ExtractedIonSignal
implements IExtractedIonSignal {
    private static final Logger logger = Logger.getLogger(ExtractedIonSignal.class);
    private float[] abundanceValues;
    private int startIon;
    private int stopIon;
    private int retentionTime;
    private float retentionIndex;

    public ExtractedIonSignal(double startIon, double stopIon) {
        int start = AbstractIon.getIon(startIon);
        int stop = AbstractIon.getIon(stopIon);
        start = start < 0 ? 0 : start;
        int n = stop = stop < 0 ? 0 : stop;
        if (startIon > stopIon) {
            this.startIon = stop;
            this.stopIon = start;
        } else {
            this.startIon = start;
            this.stopIon = stop;
        }
        int count = this.stopIon - this.startIon + 1;
        if (count > 0) {
            this.abundanceValues = new float[count];
        }
    }

    public ExtractedIonSignal(List<IIon> ions) {
        if (ions != null && ions.size() > 0) {
            Collections.sort(ions, new IonValueComparator());
            this.startIon = AbstractIon.getIon(ions.get(0).getIon());
            this.stopIon = AbstractIon.getIon(ions.get(ions.size() - 1).getIon());
            int count = this.stopIon - this.startIon + 1;
            if (count > 0) {
                this.abundanceValues = new float[count];
            }
            for (IIon ion : ions) {
                this.setAbundance(ion);
            }
        }
    }

    @Override
    public void setAbundance(IIon ion, boolean removePreviousAbundance) {
        if (removePreviousAbundance) {
            int ionActual = AbstractIon.getIon(ion.getIon());
            if (this.isValidIon(ionActual)) {
                int position = ionActual - this.startIon;
                this.abundanceValues[position] = ion.getAbundance();
            }
        } else {
            this.setAbundance(ion);
        }
    }

    @Override
    public void setAbundance(IIon ion) {
        int ionActual = AbstractIon.getIon(ion.getIon());
        if (this.isValidIon(ionActual)) {
            int position;
            int n = position = ionActual - this.startIon;
            this.abundanceValues[n] = this.abundanceValues[n] + ion.getAbundance();
        }
    }

    @Override
    public void setAbundance(int ion, float abundance) {
        try {
            Ion defaultIon = new Ion(ion, abundance);
            this.setAbundance(defaultIon);
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public void setAbundance(int ion, float abundance, boolean removePreviousAbundance) {
        try {
            Ion defaultIon = new Ion(ion, abundance);
            this.setAbundance(defaultIon, removePreviousAbundance);
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public float getAbundance(int ion) {
        if (this.isValidIon(ion)) {
            int position = ion - this.startIon;
            return this.abundanceValues[position];
        }
        return 0.0f;
    }

    @Override
    public int getNumberOfIonValues() {
        if (this.abundanceValues == null) {
            return 0;
        }
        return this.abundanceValues.length;
    }

    @Override
    public float getTotalSignal() {
        float totalSignal = 0.0f;
        if (this.abundanceValues != null && this.abundanceValues.length > 0) {
            totalSignal = Calculations.getSum((float[])this.abundanceValues);
        }
        return totalSignal;
    }

    @Override
    public int getIonMaxIntensity() {
        if (this.abundanceValues.length == 0) {
            return 0;
        }
        float maxIntensity = this.getMaxIntensity();
        if (maxIntensity == 0.0f) {
            return 0;
        }
        int i = 0;
        while (i < this.abundanceValues.length) {
            if (this.abundanceValues[i] == maxIntensity) {
                return i + this.startIon;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public float getMaxIntensity() {
        return Calculations.getMax((float[])this.abundanceValues);
    }

    @Override
    public float getMinIntensity() {
        return Calculations.getMin((float[])this.abundanceValues);
    }

    @Override
    public float getMedianIntensity() {
        return Calculations.getMedian((float[])this.abundanceValues);
    }

    @Override
    public int getRetentionTime() {
        return this.retentionTime;
    }

    @Override
    public void setRetentionTime(int retentionTime) {
        if (retentionTime >= 0) {
            this.retentionTime = retentionTime;
        }
    }

    @Override
    public float getRetentionIndex() {
        return this.retentionIndex;
    }

    @Override
    public void setRetentionIndex(float retentionIndex) {
        if (retentionIndex >= 0.0f) {
            this.retentionIndex = retentionIndex;
        }
    }

    @Override
    public int getStartIon() {
        return this.startIon;
    }

    @Override
    public int getStopIon() {
        return this.stopIon;
    }

    @Override
    public IIonRange getIonRange() {
        IonRange ionRange = new IonRange(this.startIon, this.stopIon);
        return ionRange;
    }

    private boolean isValidIon(int ion) {
        if (this.abundanceValues == null) {
            return false;
        }
        return ion >= this.startIon && ion <= this.stopIon;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ExtractedIonSignal extractedIonSignal = (ExtractedIonSignal)otherObject;
        return this.startIon == extractedIonSignal.startIon && this.stopIon == extractedIonSignal.stopIon && this.getNumberOfIonValues() == extractedIonSignal.getNumberOfIonValues() && this.getTotalSignal() == extractedIonSignal.getTotalSignal();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.startIon).hashCode() + 9 * Integer.valueOf(this.stopIon).hashCode() + 11 * Integer.valueOf(this.getNumberOfIonValues()).hashCode() + 13 * Float.valueOf(this.getTotalSignal()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startIon=" + this.startIon);
        builder.append(",");
        builder.append("stopIon=" + this.stopIon);
        builder.append(",");
        builder.append("numberOfIonValues=" + this.getNumberOfIonValues());
        builder.append(",");
        builder.append("totalSignal=" + this.getTotalSignal());
        builder.append("]");
        return builder.toString();
    }
}

