/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverterSupport;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.swt.ui.Activator;
import org.eclipse.chemclipse.msd.swt.ui.internal.support.MassSpectraExportRunnable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class MassSpectraFileSupport {
    private static final Logger logger = Logger.getLogger(MassSpectraFileSupport.class);

    private MassSpectraFileSupport() {
    }

    public static boolean saveMassSpectra(IMassSpectra massSpectra) throws NoConverterAvailableException {
        Shell shell = Display.getCurrent().getActiveShell();
        if (massSpectra == null || shell == null) {
            return false;
        }
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterPath(Activator.getDefault().getSettingsPath());
        dialog.setFileName(massSpectra.getName());
        dialog.setText("Save Mass Spectra As");
        dialog.setOverwrite(true);
        MassSpectrumConverterSupport converterSupport = MassSpectrumConverter.getMassSpectrumConverterSupport();
        String[] filterExtensions = converterSupport.getExportableFilterExtensions();
        dialog.setFilterExtensions(filterExtensions);
        String[] filterNames = converterSupport.getExportableFilterNames();
        dialog.setFilterNames(filterNames);
        String filename = dialog.open();
        if (filename != null) {
            MassSpectraFileSupport.validateFile(dialog, converterSupport.getExportSupplier(), shell, converterSupport, massSpectra);
            return true;
        }
        return false;
    }

    public static void writeFile(File file, IMassSpectra massSpectra, ISupplier supplier) {
        if (file == null || massSpectra == null || supplier == null) {
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        MassSpectraExportRunnable runnable = new MassSpectraExportRunnable(file, massSpectra, supplier);
        try {
            dialog.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        File data = runnable.getData();
        if (data == null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Save Mass Spectra", (String)"There is not suitable mass spectra converter available.");
        }
    }

    private static void validateFile(FileDialog dialog, List<ISupplier> supplier, Shell shell, MassSpectrumConverterSupport converterSupport, IMassSpectra massSpectra) {
        File massSpectrumFolder = null;
        boolean overwrite = dialog.getOverwrite();
        boolean folderExists = false;
        boolean isDirectory = false;
        ISupplier selectedSupplier = supplier.get(dialog.getFilterIndex());
        if (selectedSupplier == null) {
            MessageDialog.openInformation((Shell)shell, (String)"Mass Spectra Converter", (String)"The requested mass spectra converter does not exists.");
            return;
        }
        String filename = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName();
        if (selectedSupplier != null) {
            String directoryExtension = selectedSupplier.getDirectoryExtension();
            if (directoryExtension != "") {
                isDirectory = true;
                filename = MassSpectraFileSupport.removeFileExtensions(filename, selectedSupplier);
                massSpectrumFolder = new File(filename = filename.concat(selectedSupplier.getDirectoryExtension()));
                if (massSpectrumFolder.exists()) {
                    folderExists = true;
                    overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite", (String)("Would you like to overwrite the mass spectra file " + massSpectrumFolder.toString() + "?"));
                }
                if (overwrite && !folderExists) {
                    massSpectrumFolder.mkdir();
                }
            } else {
                File chromatogramFile;
                String filenameDialog;
                filename = MassSpectraFileSupport.removeFileExtensions(filename, selectedSupplier);
                if (!(filename = filename.concat(selectedSupplier.getFileExtension())).equals(filenameDialog = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName()) && (chromatogramFile = new File(filename)).exists()) {
                    overwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite", (String)("Would you like to overwrite the mass spectra file " + chromatogramFile.toString() + "?"));
                }
            }
            if (overwrite) {
                if (isDirectory) {
                    if (!folderExists && massSpectrumFolder != null) {
                        massSpectrumFolder.mkdir();
                    }
                } else {
                    String fileExtension = selectedSupplier.getFileExtension();
                    if (!filename.endsWith(fileExtension)) {
                        filename = String.valueOf(filename) + fileExtension;
                    }
                }
                MassSpectraFileSupport.writeFile(new File(filename), massSpectra, selectedSupplier);
            }
        }
    }

    private static String removeFileExtensions(String filePath, ISupplier supplier) {
        int start = 0;
        int stop = 0;
        if (supplier.getDirectoryExtension().equals("")) {
            String fileExtension = supplier.getFileExtension();
            if (filePath.endsWith(fileExtension) || filePath.endsWith(fileExtension.toLowerCase()) || filePath.endsWith(fileExtension.toUpperCase())) {
                stop = filePath.length() - fileExtension.length();
                filePath = filePath.substring(start, stop);
            }
        } else {
            String directoryExtension = supplier.getDirectoryExtension();
            if (filePath.endsWith(directoryExtension) || filePath.endsWith(directoryExtension.toLowerCase()) || filePath.endsWith(directoryExtension.toUpperCase())) {
                stop = filePath.length() - directoryExtension.length();
                filePath = filePath.substring(start, stop);
            }
        }
        return filePath;
    }
}

