/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassSpectrumListUI;
import org.eclipse.chemclipse.support.ui.swt.IListItemsRemoveListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class MassSpectrumSearchListUI
extends Composite {
    private static final int MAX_SPECTRA_LOAD_COMPLETE = 5000;
    private static final int SIZE_SEARCH_RESTRICTION = 15000;
    private Text textSearch;
    private Button checkboxCaseSensitive;
    private Label labelInfo;
    private MassSpectrumListUI massSpectrumListUI;
    private int massSpectraSize = 0;
    private List<IListItemsRemoveListener> listItemRemoveListeners = new ArrayList<IListItemsRemoveListener>();

    public MassSpectrumSearchListUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setSearchSelection(String searchString) {
        this.textSearch.setText(searchString);
        this.search();
    }

    public boolean setFocus() {
        return this.massSpectrumListUI.getTable().setFocus();
    }

    public void addListItemsRemoveListener(IListItemsRemoveListener listItemRemoveListener) {
        this.listItemRemoveListeners.add(listItemRemoveListener);
    }

    public void removeListItemsRemoveListener(IListItemsRemoveListener listItemRemoveListener) {
        this.listItemRemoveListeners.remove(listItemRemoveListener);
    }

    public void update(IMassSpectra massSpectra, boolean forceReload) {
        if (massSpectra != null) {
            if (massSpectra.size() > 5000) {
                String searchString = "Please use this filter";
                this.massSpectrumListUI.setSearchText(searchString, true);
                this.textSearch.setText(searchString);
            }
            this.massSpectrumListUI.setInput(massSpectra);
            this.massSpectraSize = massSpectra.size();
            this.updateLabel();
        }
    }

    public void clear() {
        this.massSpectrumListUI.setInput(null);
    }

    public TableViewer getTableViewer() {
        return this.massSpectrumListUI;
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout(3, false));
        this.setLayoutData(new GridData(1808));
        this.textSearch = new Text((Composite)this, 2048);
        this.textSearch.setText("");
        this.textSearch.setLayoutData((Object)new GridData(768));
        this.textSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (MassSpectrumSearchListUI.this.massSpectraSize >= 15000) {
                    int length = MassSpectrumSearchListUI.this.textSearch.getText().length();
                    if (length == 0) {
                        MassSpectrumSearchListUI.this.search();
                    } else if (length >= 5) {
                        MassSpectrumSearchListUI.this.search();
                    }
                } else {
                    MassSpectrumSearchListUI.this.search();
                }
            }
        });
        Button button = new Button((Composite)this, 8);
        button.setText("Search");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumSearchListUI.this.search();
            }
        });
        this.checkboxCaseSensitive = new Button((Composite)this, 32);
        this.checkboxCaseSensitive.setText("Case sensitive");
        this.checkboxCaseSensitive.setSelection(true);
        this.checkboxCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MassSpectrumSearchListUI.this.search();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.massSpectrumListUI = new MassSpectrumListUI(this, 66306);
        this.massSpectrumListUI.getTable().setLayoutData((Object)gridData);
        this.massSpectrumListUI.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && e.stateMask == 0) {
                    MassSpectrumSearchListUI.this.deleteSelectedTargets();
                }
            }
        });
        this.labelInfo = new Label((Composite)this, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
    }

    private void search() {
        String searchText = this.textSearch.getText().trim();
        boolean caseSensitive = this.checkboxCaseSensitive.getSelection();
        this.massSpectrumListUI.setSearchText(searchText, caseSensitive);
        this.updateLabel();
    }

    private void deleteSelectedTargets() {
        Shell shell = Display.getCurrent().getActiveShell();
        MessageBox messageBox = new MessageBox(shell, 456);
        messageBox.setText("Delete Selected Targets");
        messageBox.setMessage("Do you really want to delete the selected targets?");
        int decision = messageBox.open();
        if (64 == decision) {
            Table table = this.massSpectrumListUI.getTable();
            int[] indices = table.getSelectionIndices();
            Object input = this.massSpectrumListUI.getInput();
            if (input instanceof IMassSpectra) {
                IMassSpectra massSpectra = (IMassSpectra)input;
                int[] nArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    massSpectra.getMassSpectrum(i + 1).removeAllTargets();
                    ++n2;
                }
            }
            table.remove(indices);
            this.fireUpdateListItemsRemoved();
        }
    }

    private void fireUpdateListItemsRemoved() {
        for (IListItemsRemoveListener listItemRemoveListener : this.listItemRemoveListeners) {
            listItemRemoveListener.update();
        }
    }

    private void updateLabel() {
        this.labelInfo.setText("Mass Spectra: " + this.massSpectraSize + " (Filtered Mass Spectra: " + this.massSpectrumListUI.getTable().getItemCount() + " [" + this.textSearch.getText().trim() + "])");
    }
}

