/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.processing.IMassSpectrumFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.processing.MassSpectrumFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.IMassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.MassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.IIonRemoverMassSpectrumFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumFilter
extends AbstractMassSpectrumFilter {
    private static final String DESCRIPTION = "Ion Remover Mass Spectrum Filter";

    public IMassSpectrumFilterProcessingInfo applyFilter(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        MassSpectrumFilterProcessingInfo processingInfo = new MassSpectrumFilterProcessingInfo();
        processingInfo.addMessages(this.validate(massSpectra, massSpectrumFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        if (massSpectrumFilterSettings instanceof IIonRemoverMassSpectrumFilterSettings) {
            IIonRemoverMassSpectrumFilterSettings ionRemoverPeakFilterSettings = (IIonRemoverMassSpectrumFilterSettings)massSpectrumFilterSettings;
            IMarkedIons markedIons = ionRemoverPeakFilterSettings.getIonsToRemove();
            for (IScanMSD massSpectrum : massSpectra) {
                massSpectrum.getTargets().clear();
                massSpectrum.removeIons(markedIons);
            }
            processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been optimized successfully."));
        } else {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of: " + IIonRemoverMassSpectrumFilterSettings.class);
        }
        MassSpectrumFilterResult massSpectrumFilterResult = new MassSpectrumFilterResult(ResultStatus.OK, "The ion remover filter has been applied successfully.");
        processingInfo.setMassSpectrumFilterResult((IMassSpectrumFilterResult)massSpectrumFilterResult);
        return processingInfo;
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(IScanMSD massSpectrum, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        return this.applyFilter(massSpectrum, massSpectrumFilterSettings, monitor);
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(IScanMSD massSpectrum, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        IMassSpectrumFilterSettings massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        return this.applyFilter(massSpectra, massSpectrumFilterSettings, monitor);
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(List<IScanMSD> massSpectra, IProgressMonitor monitor) {
        IMassSpectrumFilterSettings massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        return this.applyFilter(massSpectra, massSpectrumFilterSettings, monitor);
    }
}

