/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.distance.comparator;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.AbstractMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.IMassSpectrumComparatorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.MassSpectrumComparatorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.distance.results.MassSpectrumComparisonResult;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumComparisonResult;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;

public class EuclideanMassSpectrumComparator
extends AbstractMassSpectrumComparator
implements IMassSpectrumComparator {
    public IMassSpectrumComparatorProcessingInfo compare(IScanMSD unknown, IScanMSD reference) {
        MassSpectrumComparatorProcessingInfo processingInfo = new MassSpectrumComparatorProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(unknown, reference);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            EuclideanDistance distanceMeasure = new EuclideanDistance();
            float matchFactor = (1.0f - this.calculateMatch(unknown.getExtractedIonSignal(), reference.getExtractedIonSignal(), (DistanceMeasure)distanceMeasure)) * 100.0f;
            float reverseMatchFactor = (1.0f - this.calculateMatch(reference.getExtractedIonSignal(), unknown.getExtractedIonSignal(), (DistanceMeasure)distanceMeasure)) * 100.0f;
            float matchFactorDirect = (1.0f - this.calculateMatchDirect(unknown.getExtractedIonSignal(), reference.getExtractedIonSignal(), (DistanceMeasure)distanceMeasure)) * 100.0f;
            float reverseMatchFactorDirect = (1.0f - this.calculateMatchDirect(reference.getExtractedIonSignal(), unknown.getExtractedIonSignal(), (DistanceMeasure)distanceMeasure)) * 100.0f;
            MassSpectrumComparisonResult massSpectrumComparisonResult = new MassSpectrumComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect);
            processingInfo.setMassSpectrumComparisonResult((IMassSpectrumComparisonResult)massSpectrumComparisonResult);
        }
        return processingInfo;
    }

    private float calculateMatch(IExtractedIonSignal unknownSignal, IExtractedIonSignal referenceSignal, DistanceMeasure distanceMeasure) {
        float match;
        int size = unknownSignal.getNumberOfIonValues();
        double[] unknown = new double[size];
        double[] reference = new double[size];
        int i = unknownSignal.getStartIon();
        int j = 0;
        while (i <= unknownSignal.getStopIon()) {
            unknown[j] = unknownSignal.getAbundance(i);
            reference[j] = referenceSignal.getAbundance(i);
            ++i;
            ++j;
        }
        try {
            float distance = (float)distanceMeasure.compute(new ArrayRealVector(unknown).unitVector().toArray(), new ArrayRealVector(reference).unitVector().toArray());
            match = 0.5f * distance;
        }
        catch (MathArithmeticException mathArithmeticException) {
            match = 1.0f;
        }
        return match;
    }

    private float calculateMatchDirect(IExtractedIonSignal unknownSignal, IExtractedIonSignal referenceSignal, DistanceMeasure distanceMeasure) {
        float match;
        ArrayList<Integer> ionList = new ArrayList<Integer>();
        int startIon = unknownSignal.getStartIon();
        int stopIon = unknownSignal.getStopIon();
        int ion = startIon;
        while (ion <= stopIon) {
            if (unknownSignal.getAbundance(ion) > 0.0f) {
                ionList.add(ion);
            }
            ++ion;
        }
        double[] unknown = new double[ionList.size()];
        double[] reference = new double[ionList.size()];
        int j = 0;
        Iterator iterator = ionList.iterator();
        while (iterator.hasNext()) {
            int ion2 = (Integer)iterator.next();
            unknown[j] = unknownSignal.getAbundance(ion2);
            reference[j] = referenceSignal.getAbundance(ion2);
            ++j;
        }
        try {
            float distance = (float)distanceMeasure.compute(new ArrayRealVector(unknown).unitVector().toArray(), new ArrayRealVector(reference).unitVector().toArray());
            match = 0.5f * distance;
        }
        catch (MathArithmeticException mathArithmeticException) {
            match = 1.0f;
        }
        return match;
    }
}

