/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.chemclipse.support.ui.internal.provider.EditHistoryContentProvider;
import org.eclipse.chemclipse.support.ui.internal.provider.EditHistoryLabelProvider;
import org.eclipse.chemclipse.support.ui.internal.provider.EditHistoryTableSorter;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EditHistoryPart {
    private static final String POPUP_MENU_ID = "org.eclipse.chemclipse.support.ui.parts.editHistoryPart.popup";
    @Inject
    private Composite parent;
    private TableViewer tableViewer;
    private String COLUMN_DATE = SupportMessages.INSTANCE().getMessage("columnDate", new String[0]);
    private String COLUMN_DESCRIPTION = SupportMessages.INSTANCE().getMessage("columnDescription", new String[0]);
    private String COLUMN_EDITOR = SupportMessages.INSTANCE().getMessage("columnEditor", new String[0]);
    private String[] titles = new String[]{this.COLUMN_DATE, this.COLUMN_DESCRIPTION, this.COLUMN_EDITOR};
    private int[] bounds = new int[]{100, 100, 100};
    private EPartService partService;
    private MPart part;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;
    private IEditHistory editHistory;
    private EditHistoryTableSorter editHistoryTableSorter;
    private Clipboard clipboard;

    @Inject
    public EditHistoryPart(EPartService partService, MPart part, IEventBroker eventBroker) {
        this.partService = partService;
        this.part = part;
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @PostConstruct
    private void createControl(IEventBroker eventBroker) {
        this.clipboard = new Clipboard(Display.getDefault());
        this.parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer(this.parent, 770);
        this.createColumns();
        this.tableViewer.setContentProvider((IContentProvider)new EditHistoryContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EditHistoryLabelProvider());
        this.editHistoryTableSorter = new EditHistoryTableSorter();
        this.tableViewer.setSorter((ViewerSorter)this.editHistoryTableSorter);
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    EditHistoryPart.this.copyToClipboard();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.initContextMenu();
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", POPUP_MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        EditHistoryPart.this.copyToClipboard();
                    }
                };
                action.setText(SupportMessages.INSTANCE().getMessage("labelCopySelectionClipboard", new String[0]));
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
    }

    @Focus
    public void setFocus() {
        this.tableViewer.getControl().setFocus();
        this.update();
    }

    public void setInput(IEditHistory editHistory) {
        if (this.doUpdate(editHistory)) {
            this.editHistory = editHistory;
            this.tableViewer.setInput((Object)editHistory);
        }
    }

    private void update() {
        if (this.doUpdate(this.editHistory)) {
            this.tableViewer.setInput((Object)this.editHistory);
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    private void createColumns() {
        int i = 0;
        while (i < this.titles.length) {
            final int index = i;
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            final TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(this.titles[i]);
            tableColumn.setWidth(this.bounds[i]);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditHistoryPart.this.editHistoryTableSorter.setColumn(index);
                    int direction = EditHistoryPart.this.tableViewer.getTable().getSortDirection();
                    direction = EditHistoryPart.this.tableViewer.getTable().getSortColumn() == tableColumn ? (direction == 128 ? 1024 : 128) : 128;
                    EditHistoryPart.this.tableViewer.getTable().setSortDirection(direction);
                    EditHistoryPart.this.tableViewer.getTable().setSortColumn(tableColumn);
                    EditHistoryPart.this.tableViewer.refresh();
                }
            });
            ++i;
        }
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private void copyToClipboard() {
        String DELIMITER = "\t";
        String END_OF_LINE = OperatingSystemUtils.getLineDelimiter();
        StringBuilder builder = new StringBuilder();
        int size = this.titles.length;
        String[] stringArray = this.titles;
        int n = this.titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            builder.append(title);
            builder.append(DELIMITER);
            ++n2;
        }
        builder.append(DELIMITER);
        Table table = this.tableViewer.getTable();
        int[] nArray = table.getSelectionIndices();
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int index = nArray[n4];
            TableItem selection = table.getItem(index);
            int columnIndex = 0;
            while (columnIndex < size) {
                builder.append(selection.getText(columnIndex));
                builder.append(DELIMITER);
                ++columnIndex;
            }
            builder.append(END_OF_LINE);
            ++n4;
        }
        if (builder.length() == 0) {
            builder.append(SupportMessages.INSTANCE().getMessage("labelSelectEntries", new String[0]));
            builder.append(END_OF_LINE);
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{builder.toString()};
        Transfer[] dataTypes = new Transfer[]{textTransfer};
        this.clipboard.setContents(data, dataTypes);
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    EditHistoryPart.this.editHistory = (IEditHistory)event.getProperty("org.eclipse.e4.data");
                    EditHistoryPart.this.update();
                }
            };
            this.eventBroker.subscribe("edithistory/update", this.eventHandler);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private boolean doUpdate(IEditHistory editHistory) {
        return this.isPartVisible() && editHistory != null;
    }
}

