/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.io.AbstractMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.model.IVendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.model.VendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public class AmdisMSLReader
extends AbstractMassSpectraReader
implements IMassSpectraReader {
    private static final Logger logger = Logger.getLogger(AmdisMSLReader.class);
    private static final int correctionFactor = 60000;
    private static final Pattern namePattern = Pattern.compile("(NAME:)(.*)", 2);
    private static final Pattern commentsPattern = Pattern.compile("(COMMENTS:)(.*)", 2);
    private static final Pattern casNumberPattern = Pattern.compile("(CASNO:)(.*)", 2);
    private static final Pattern smilesPattern = Pattern.compile("(SMILES:)(.*)", 2);
    private static final Pattern retentionTimePattern = Pattern.compile("(RT:)(.*)", 2);
    private static final Pattern retentionIndexPattern = Pattern.compile("(RI:)(.*)", 2);
    private static final Pattern ionPattern = Pattern.compile("(\\d+)(\\s+)(\\d+)");
    private static final String RETENTION_INDICES_DELIMITER = ", ";

    public IMassSpectra read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        List<String> massSpectraData = this.getMassSpectraData(file);
        IMassSpectra massSpectra = this.extractMassSpectra(massSpectraData);
        massSpectra.setConverterId("org.eclipse.chemclipse.msd.converter.supplier.amdis.massspectrum.msl");
        massSpectra.setName(file.getName());
        return massSpectra;
    }

    private List<String> getMassSpectraData(File file) throws IOException {
        String line;
        Charset charSet = Charset.forName("US-ASCII");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, charSet);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ArrayList<String> massSpectraData = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            if (line.length() == 0) {
                this.addMassSpectrumData(builder, massSpectraData);
                builder = new StringBuilder();
                continue;
            }
            builder.append(line);
            builder.append("\r\n");
        }
        this.addMassSpectrumData(builder, massSpectraData);
        bufferedReader.close();
        inputStreamReader.close();
        bufferedInputStream.close();
        return massSpectraData;
    }

    private void addMassSpectrumData(StringBuilder builder, List<String> massSpectraData) {
        if (builder.length() > 0) {
            String massSpectrumData = builder.toString();
            massSpectraData.add(massSpectrumData);
        }
    }

    private IMassSpectra extractMassSpectra(List<String> massSpectraData) {
        MassSpectra massSpectra = new MassSpectra();
        String referenceIdentifierMarker = PreferenceSupplier.getReferenceIdentifierMarker();
        String referenceIdentifierPrefix = PreferenceSupplier.getReferenceIdentifierPrefix();
        for (String massSpectrumData : massSpectraData) {
            this.addMassSpectrum((IMassSpectra)massSpectra, massSpectrumData, referenceIdentifierMarker, referenceIdentifierPrefix);
        }
        return massSpectra;
    }

    private void addMassSpectrum(IMassSpectra massSpectra, String massSpectrumData, String referenceIdentifierMarker, String referenceIdentifierPrefix) {
        VendorLibraryMassSpectrum massSpectrum = new VendorLibraryMassSpectrum();
        String name = this.extractContentAsString(massSpectrumData, namePattern);
        this.extractNameAndReferenceIdentifier(massSpectrum, name, referenceIdentifierMarker, referenceIdentifierPrefix);
        String comments = this.extractContentAsString(massSpectrumData, commentsPattern);
        massSpectrum.getLibraryInformation().setComments(comments);
        String casNumber = this.extractContentAsString(massSpectrumData, casNumberPattern);
        massSpectrum.getLibraryInformation().setCasNumber(casNumber);
        String smiles = this.extractContentAsString(massSpectrumData, smilesPattern);
        massSpectrum.getLibraryInformation().setSmiles(smiles);
        int retentionTime = this.extractContentAsInt(massSpectrumData, retentionTimePattern);
        massSpectrum.setRetentionTime(retentionTime);
        String retentionIndices = this.extractContentAsString(massSpectrumData, retentionIndexPattern);
        this.extractRetentionIndices(massSpectrum, retentionIndices, RETENTION_INDICES_DELIMITER);
        this.extractIons(massSpectrum, massSpectrumData);
        if (massSpectrum.getNumberOfIons() > 0) {
            massSpectra.addMassSpectrum((IScanMSD)massSpectrum);
        }
    }

    private void extractIons(IVendorLibraryMassSpectrum massSpectrum, String massSpectrumData) {
        Ion amdisIon = null;
        Matcher ions = ionPattern.matcher(massSpectrumData);
        while (ions.find()) {
            try {
                double ion = Double.parseDouble(ions.group(1));
                float abundance = Float.parseFloat(ions.group(3));
                amdisIon = new Ion(ion, abundance);
                massSpectrum.addIon((IIon)amdisIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
    }

    private String extractContentAsString(String massSpectrumData, Pattern pattern) {
        String content = "";
        Matcher matcher = pattern.matcher(massSpectrumData);
        if (matcher.find()) {
            content = matcher.group(2).trim();
        }
        return content;
    }

    private int extractContentAsInt(String massSpectrumData, Pattern pattern) {
        int content = 0;
        try {
            Matcher matcher = pattern.matcher(massSpectrumData);
            if (matcher.find()) {
                content = (int)(Float.parseFloat(matcher.group(2).trim()) * 60000.0f);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return content;
    }
}

