/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.IPeakMSDSelectionView;
import org.eclipse.chemclipse.ux.extension.ui.definitions.PeakType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractPeakMSDSelectionView
extends AbstractSelectionView
implements IPeakMSDSelectionView {
    private IPeakMSD peak;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractPeakMSDSelectionView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IPeakMSD getPeak() {
        if (this.peak == null) {
            this.peak = PeakType.getSelectedPeakMSD();
        }
        return this.peak;
    }

    @Override
    public void setPeak(IPeakMSD peak) {
        this.peak = peak;
    }

    @Override
    public boolean doUpdate(IPeakMSD peak) {
        return this.isPartVisible() && peak != null;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractPeakMSDSelectionView.this.peak = (IPeakMSD)event.getProperty("PeakMSD");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractPeakMSDSelectionView.this.update(AbstractPeakMSDSelectionView.this.peak, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/peak", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

