/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ui.ide.undo.ResourceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoablePackageDeleteChange
extends DynamicValidationStateChange {
    private final List<IResource> fPackageDeletes;

    public UndoablePackageDeleteChange(String name, List<IResource> packageDeletes) {
        super(name);
        this.fPackageDeletes = packageDeletes;
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        int count = this.fPackageDeletes.size();
        pm.beginTask("", count * 3);
        ResourceDescription[] packageDeleteDescriptions = new ResourceDescription[this.fPackageDeletes.size()];
        int i = 0;
        while (i < this.fPackageDeletes.size()) {
            IResource resource = this.fPackageDeletes.get(i);
            packageDeleteDescriptions[i] = ResourceDescription.fromResource((IResource)resource);
            pm.worked(1);
            ++i;
        }
        DynamicValidationStateChange result = (DynamicValidationStateChange)super.perform((IProgressMonitor)new SubProgressMonitor(pm, count));
        int i2 = 0;
        while (i2 < this.fPackageDeletes.size()) {
            IResource resource = this.fPackageDeletes.get(i2);
            ResourceDescription resourceDescription = packageDeleteDescriptions[i2];
            resourceDescription.recordStateFromHistory(resource, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.add(new UndoDeleteResourceChange(resourceDescription));
            ++i2;
        }
        return result;
    }
}

