/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.views;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.ux.extension.xxd.ui.views.AbstractChromatogramOverviewView;
import org.eclipse.chemclipse.ux.extension.xxd.ui.views.IChromatogramOverviewView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ChromatogramHeaderView
extends AbstractChromatogramOverviewView
implements IChromatogramOverviewView {
    private Text text;
    private SimpleDateFormat dateFormat = ValueFormat.getDateFormatEnglish();
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    @Inject
    public ChromatogramHeaderView(Composite parent, MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.text = new Text(parent, 2818);
    }

    @Focus
    public void setFocus() {
        this.text.setFocus();
    }

    @Override
    public void updateChromatogram(IChromatogramOverview chromatogramOverview) {
        if (this.doUpdate(chromatogramOverview)) {
            StringBuilder builder = new StringBuilder();
            this.addHeaderLine(builder, "Name", chromatogramOverview.getName());
            this.addHeaderLine(builder, "Data Name", chromatogramOverview.getDataName());
            this.addHeaderLine(builder, "Operator", chromatogramOverview.getOperator());
            Date date = chromatogramOverview.getDate();
            if (date != null) {
                this.addHeaderLine(builder, "Date", this.dateFormat.format(chromatogramOverview.getDate()));
            } else {
                this.addHeaderLine(builder, "Date", "");
            }
            this.addHeaderLine(builder, "Info", chromatogramOverview.getShortInfo());
            this.addHeaderLine(builder, "Misc", chromatogramOverview.getMiscInfo());
            this.addHeaderLine(builder, "Misc (separated)", chromatogramOverview.getMiscInfoSeparated());
            this.addHeaderLine(builder, "Details", chromatogramOverview.getDetailedInfo());
            this.addHeaderLine(builder, "Scans", Integer.toString(chromatogramOverview.getNumberOfScans()));
            this.addHeaderLine(builder, "Start RT (min)", this.decimalFormat.format((double)chromatogramOverview.getStartRetentionTime() / 60000.0));
            this.addHeaderLine(builder, "Stop RT (min)", this.decimalFormat.format((double)chromatogramOverview.getStopRetentionTime() / 60000.0));
            this.addHeaderLine(builder, "Barcode", chromatogramOverview.getBarcode());
            this.text.setText(builder.toString());
        }
    }

    private void addHeaderLine(StringBuilder builder, String key, String value) {
        builder.append(key);
        builder.append(": ");
        builder.append(value);
        builder.append("\n");
    }
}

