/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.converter;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.msd.swt.ui.converter.ConverterMSD;
import org.eclipse.chemclipse.msd.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.exceptions.SolverException;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.exceptions.NoIdentifiedScansAvailableException;
import org.eclipse.chemclipse.swt.ui.exceptions.NoPeaksAvailableException;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.MultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.Series;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class SeriesConverterMSD {
    public static final Logger logger = Logger.getLogger(SeriesConverterMSD.class);

    private SeriesConverterMSD() {
    }

    public static IMultipleSeries convertChromatogram(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons selectedIons, boolean combine, Sign sign) {
        MultipleSeries ionSeries = new MultipleSeries();
        if (chromatogramSelection != null) {
            IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            try {
                ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
                IExtractedIonSignals signals = extractedIonSignalExtractor.getExtractedIonSignals(startScan, stopScan);
                if (combine) {
                    ISeries series = SeriesConverterMSD.getSelectedIonsAsCombinedSeries(selectedIons, signals, sign);
                    ionSeries.add(series);
                } else {
                    for (IMarkedIon markedIon : selectedIons) {
                        int ion = AbstractIon.getIon((double)markedIon.getIon());
                        ISeries series = SeriesConverterMSD.getSelectedIonAsSeries(ion, markedIon.getMagnification(), signals, sign);
                        ionSeries.add(series);
                    }
                }
            }
            catch (ChromatogramIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return ionSeries;
    }

    public static IMultipleSeries convertChromatogram(IChromatogramMSD chromatogram, IMarkedIons selectedIons, boolean combine, Sign sign, int startScan, int stopScan) {
        MultipleSeries ionSeries = new MultipleSeries();
        if (chromatogram != null) {
            try {
                ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
                IExtractedIonSignals signals = extractedIonSignalExtractor.getExtractedIonSignals(startScan, stopScan);
                if (combine) {
                    ISeries series = SeriesConverterMSD.getSelectedIonsAsCombinedSeries(selectedIons, signals, sign);
                    ionSeries.add(series);
                } else {
                    for (IMarkedIon markedIon : selectedIons) {
                        int ion = AbstractIon.getIon((double)markedIon.getIon());
                        ISeries series = SeriesConverterMSD.getSelectedIonAsSeries(ion, markedIon.getMagnification(), signals, sign);
                        ionSeries.add(series);
                    }
                }
            }
            catch (ChromatogramIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return ionSeries;
    }

    public static IMultipleSeries convertChromatogramAccurate(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons selectedIons, boolean combine, Sign sign, int precision) {
        MultipleSeries ionSeries = new MultipleSeries();
        if (chromatogramSelection != null) {
            IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            ScanRange scanRange = new ScanRange(startScan, stopScan);
            if (combine) {
                ISeries series = SeriesConverterMSD.getSelectedAccurateIonsAsCombinedSeries(selectedIons, chromatogram, scanRange, sign, precision);
                ionSeries.add(series);
            } else {
                for (IMarkedIon markedIon : selectedIons) {
                    ISeries series = SeriesConverterMSD.getSelectedAccurateIonAsSeries(markedIon.getIon(), chromatogram, scanRange, sign, precision);
                    ionSeries.add(series);
                }
            }
        }
        return ionSeries;
    }

    public static IMultipleSeries convertChromatogramExact(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons selectedIons, boolean combine, Sign sign) {
        MultipleSeries ionSeries = new MultipleSeries();
        if (chromatogramSelection != null) {
            IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            ScanRange scanRange = new ScanRange(startScan, stopScan);
            if (combine) {
                ISeries series = SeriesConverterMSD.getSelectedExactIonsAsCombinedSeries(selectedIons, chromatogram, scanRange, sign);
                ionSeries.add(series);
            } else {
                for (IMarkedIon markedIon : selectedIons) {
                    ISeries series = SeriesConverterMSD.getSelectedExactIonAsSeries(markedIon.getIon(), chromatogram, scanRange, sign);
                    ionSeries.add(series);
                }
            }
        }
        return ionSeries;
    }

    public static IMultipleSeries convertIonTranstionChromatogram(IChromatogramSelectionMSD chromatogramSelection, Set<IIonTransition> ionTransitions) {
        MultipleSeries ionSeries = new MultipleSeries();
        if (chromatogramSelection != null) {
            IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            ScanRange scanRange = new ScanRange(startScan, stopScan);
            for (IIonTransition ionTransition : ionTransitions) {
                ISeries series = SeriesConverterMSD.getSelectedIonTransitionAsSeries(ionTransition, chromatogram, scanRange);
                ionSeries.add(series);
            }
        }
        return ionSeries;
    }

    public static ISeries convertChromatogramBySelectedIons(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons selectedIons, Sign sign) {
        IMultipleSeries chromatogramSeries = SeriesConverterMSD.convertChromatogram(chromatogramSelection, selectedIons, true, sign);
        return (ISeries)chromatogramSeries.getMultipleSeries().get(0);
    }

    public static ISeries convertChromatogramByExcludedIons(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons excludedIons, Sign sign) {
        ISeries ionSeries = null;
        if (chromatogramSelection != null) {
            IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            try {
                ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
                IExtractedIonSignals signals = extractedIonSignalExtractor.getExtractedIonSignals(startScan, stopScan);
                ionSeries = SeriesConverterMSD.getIonSeriesWithoutExcludedIons(excludedIons, signals, sign);
            }
            catch (ChromatogramIsNullException e) {
                logger.warn((Object)e);
            }
        }
        return ionSeries;
    }

    public static ISeries convertPeakMaxPositions(IChromatogramSelectionMSD chromatogramSelection, IOffset offset, Sign sign, boolean activeForAnalysis) throws NoPeaksAvailableException {
        List chromatogramPeaks = chromatogramSelection.getChromatogramMSD().getPeaks(chromatogramSelection);
        IMultipleSeries peakSeries = SeriesConverter.convertPeakMaxMarker((List)chromatogramPeaks, (Sign)sign, (IOffset)offset, (boolean)activeForAnalysis);
        return (ISeries)peakSeries.getMultipleSeries().get(0);
    }

    public static ISeries convertIdentifiedScans(IChromatogramSelectionMSD chromatogramSelection, IOffset offset, Sign sign) throws NoIdentifiedScansAvailableException {
        IMassSpectra massSpectra = SeriesConverterMSD.getIdentifiedScans(chromatogramSelection, false);
        IMultipleSeries identifiedScansSeries = SeriesConverterMSD.convertIdentifiedScans(massSpectra, sign, offset);
        return (ISeries)identifiedScansSeries.getMultipleSeries().get(0);
    }

    public static IMassSpectra getIdentifiedScans(IChromatogramSelectionMSD chromatogramSelection, boolean enforceLoadScanProxy) {
        MassSpectra massSpectra = new MassSpectra();
        List scans = chromatogramSelection.getChromatogram().getScans();
        int startRetentionTime = chromatogramSelection.getStartRetentionTime();
        int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
        for (IScan scan : scans) {
            int retentionTime;
            IVendorMassSpectrum massSpectrum;
            if (!(scan instanceof IVendorMassSpectrum) || (massSpectrum = (IVendorMassSpectrum)scan).getTargets().size() <= 0 || (retentionTime = massSpectrum.getRetentionTime()) < startRetentionTime || retentionTime > stopRetentionTime) continue;
            if (enforceLoadScanProxy) {
                massSpectrum.enforceLoadScanProxy();
            }
            massSpectra.addMassSpectrum((IScanMSD)massSpectrum);
        }
        return massSpectra;
    }

    public static IMultipleSeries convertIdentifiedScans(IMassSpectra massSpectra, Sign sign, IOffset offset) throws NoIdentifiedScansAvailableException {
        MultipleSeries identifiedScanSeries = new MultipleSeries();
        if (massSpectra != null) {
            offset = SeriesConverter.validateOffset((IOffset)offset);
            if (massSpectra.size() == 0) {
                throw new NoIdentifiedScansAvailableException();
            }
            int amountIdentifiedScans = massSpectra.size();
            double[] xSeries = new double[amountIdentifiedScans];
            double[] ySeries = new double[amountIdentifiedScans];
            int x = 0;
            int y = 0;
            for (IScanMSD identifiedScan : massSpectra.getList()) {
                double retentionTime = identifiedScan.getRetentionTime();
                double abundance = identifiedScan.getTotalSignal();
                double xOffset = offset.getCurrentXOffset();
                double yOffset = offset.getCurrentYOffset();
                if (sign == Sign.NEGATIVE) {
                    abundance *= -1.0;
                    xOffset *= -1.0;
                    yOffset *= -1.0;
                }
                xSeries[x++] = retentionTime += xOffset;
                ySeries[y++] = abundance += yOffset;
                identifiedScanSeries.add((ISeries)new Series(xSeries, ySeries, "Identified Scans"));
            }
        }
        return identifiedScanSeries;
    }

    public static IMultipleSeries convertChromatogramsUseSelectedIons(List<IChromatogramSelection> chromatogramSelections, Sign sign, IOffset offset) {
        MultipleSeries chromatogramSeries = new MultipleSeries();
        if (chromatogramSelections != null && chromatogramSelections.size() >= 1) {
            offset = SeriesConverter.validateOffset((IOffset)offset);
            IChromatogramSelection masterSelection = chromatogramSelections.get(0);
            int masterStartRetentionTime = masterSelection.getStartRetentionTime();
            int masterStopRetentionTime = masterSelection.getStopRetentionTime();
            IMarkedIons selectedIons = null;
            if (masterSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD masterMSD = (IChromatogramSelectionMSD)masterSelection;
                selectedIons = masterMSD.getSelectedIons();
            }
            if (selectedIons == null) {
                selectedIons = new MarkedIons();
            }
            int counter = 0;
            for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                ++counter;
                int startScan = SeriesConverter.getStartScan((int)masterStartRetentionTime, (IChromatogram)chromatogram);
                int stopScan = SeriesConverter.getStopScan((int)masterStopRetentionTime, (IChromatogram)chromatogram);
                if (startScan == 0 || stopScan == 0 || !(chromatogramSelection instanceof IChromatogramSelectionMSD)) continue;
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                IMultipleSeries multipleSeries = SeriesConverterMSD.convertChromatogram(chromatogramSelectionMSD.getChromatogramMSD(), selectedIons, true, sign, startScan, stopScan);
                ISeries series = (ISeries)multipleSeries.getMultipleSeries().get(0);
                offset.incrementCurrentXOffset();
                offset.incrementCurrentYOffset();
                chromatogramSeries.add((ISeries)new Series(series.getXSeries(), series.getYSeries(), "[" + counter + "] " + chromatogram.getName() + " > " + selectedIons.getIonsNominal()));
            }
        }
        return chromatogramSeries;
    }

    public static ISeries convertNominalMassSpectrum(IScanMSD massSpectrum, Sign sign) {
        ISeries massSpectrumSeries = null;
        if (massSpectrum != null && massSpectrum.getTotalSignal() > 0.0f) {
            List<IIon> ionList = ConverterMSD.getFilteredIons(massSpectrum);
            ExtractedIonSignal extractedIonSignal = new ExtractedIonSignal(ionList);
            int startIon = extractedIonSignal.getStartIon() - 1;
            int stopIon = extractedIonSignal.getStopIon() + 1;
            int ions = stopIon - startIon + 1;
            double[] xSeries = new double[ions];
            double[] ySeries = new double[ions];
            int x = 0;
            int y = 0;
            int ion = startIon;
            while (ion <= stopIon) {
                xSeries[x++] = ion;
                double signal = extractedIonSignal.getAbundance(ion);
                if (sign == Sign.NEGATIVE) {
                    signal *= -1.0;
                }
                ySeries[y++] = signal;
                ++ion;
            }
            IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
            boolean filterMassSpectrum = preferences.getBoolean("filterMassSpectrum", false);
            String label = "Nominal MS";
            if (filterMassSpectrum) {
                label = String.valueOf(label) + "*";
            }
            massSpectrumSeries = new Series(xSeries, ySeries, label);
        } else {
            massSpectrumSeries = SeriesConverterMSD.getZeroMassSpectrumSeries();
        }
        return massSpectrumSeries;
    }

    public static IMultipleSeries convertNominalMassSpectrum(IScanMSD massSpectrum, IScanMSD mirroredMassSpectrum) {
        MultipleSeries massSpectrumSeries = new MultipleSeries();
        massSpectrumSeries.add(SeriesConverterMSD.convertNominalMassSpectrum(massSpectrum, Sign.POSITIVE));
        massSpectrumSeries.add(SeriesConverterMSD.convertNominalMassSpectrum(mirroredMassSpectrum, Sign.NEGATIVE));
        return massSpectrumSeries;
    }

    public static ISeries convertExactMassSpectrum(IScanMSD massSpectrum, Sign sign) {
        ISeries massSpectrumSeries = null;
        if (massSpectrum != null && massSpectrum.getTotalSignal() > 0.0f) {
            double startIon = massSpectrum.getLowestIon().getIon() - 1.0;
            double stopIon = massSpectrum.getHighestIon().getIon() + 1.0;
            int ions = massSpectrum.getNumberOfIons() + 2;
            double[] xSeries = new double[ions];
            double[] ySeries = new double[ions];
            int x = 0;
            int y = 0;
            xSeries[x++] = startIon;
            ySeries[y++] = 0.0;
            for (IIon ion : massSpectrum.getIons()) {
                xSeries[x++] = ion.getIon();
                double signal = ion.getAbundance();
                if (sign == Sign.NEGATIVE) {
                    signal *= -1.0;
                }
                ySeries[y++] = signal;
            }
            xSeries[x++] = stopIon;
            ySeries[y++] = 0.0;
            massSpectrumSeries = new Series(xSeries, ySeries, "Exact MS");
        } else {
            massSpectrumSeries = SeriesConverterMSD.getZeroMassSpectrumSeries();
        }
        return massSpectrumSeries;
    }

    private static ISeries getZeroMassSpectrumSeries() {
        double[] xSeries = new double[]{0.0, 0.0};
        double[] ySeries = new double[]{0.0, 0.0};
        return new Series(xSeries, ySeries, "no mass spectrum available");
    }

    public static ISeries convertIncreasingInflectionPoints(IPeakMSD peak, boolean includeBackground, Sign sign) {
        Series series = null;
        if (peak != null) {
            IPeakModelMSD peakModel = peak.getPeakModel();
            double[] xSeries = new double[2];
            double[] ySeries = new double[2];
            try {
                LinearEquation increasing = peakModel.getIncreasingInflectionPointEquation();
                LinearEquation decreasing = peakModel.getDecreasingInflectionPointEquation();
                LinearEquation baseline = peakModel.getPercentageHeightBaselineEquation(0.0f);
                IPoint intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)baseline);
                double startRetentionTime = peakModel.getStartRetentionTime();
                double x = intersection.getX() < startRetentionTime ? startRetentionTime : intersection.getX();
                xSeries[0] = intersection.getX();
                ySeries[0] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
                intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)decreasing);
                double stopRetentionTime = peakModel.getStopRetentionTime();
                x = intersection.getX() > stopRetentionTime ? stopRetentionTime : intersection.getX();
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
            }
            catch (SolverException solverException) {}
            series = new Series(xSeries, ySeries, "Increasing Tangent");
        }
        return series;
    }

    public static ISeries convertDecreasingInflectionPoints(IPeakMSD peak, boolean includeBackground, Sign sign) {
        Series series = null;
        if (peak != null) {
            IPeakModelMSD peakModel = peak.getPeakModel();
            double[] xSeries = new double[2];
            double[] ySeries = new double[2];
            try {
                LinearEquation increasing = peakModel.getIncreasingInflectionPointEquation();
                LinearEquation decreasing = peakModel.getDecreasingInflectionPointEquation();
                LinearEquation baseline = peakModel.getPercentageHeightBaselineEquation(0.0f);
                IPoint intersection = Equations.calculateIntersection((LinearEquation)decreasing, (LinearEquation)baseline);
                double stopRetentionTime = peakModel.getStopRetentionTime();
                double x = intersection.getX() > stopRetentionTime ? stopRetentionTime : intersection.getX();
                xSeries[0] = intersection.getX();
                ySeries[0] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
                intersection = Equations.calculateIntersection((LinearEquation)increasing, (LinearEquation)decreasing);
                double startRetentionTime = peakModel.getStartRetentionTime();
                x = intersection.getX() < startRetentionTime ? startRetentionTime : intersection.getX();
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)x) : intersection.getY();
            }
            catch (SolverException solverException) {}
            series = new Series(xSeries, ySeries, "Decreasing Tangent");
        }
        return series;
    }

    public static ISeries convertPeakPerpendicular(IPeakMSD peak, boolean includeBackground, Sign sign) {
        Series series = null;
        if (peak != null) {
            IPeakModelMSD peakModel = peak.getPeakModel();
            double[] xSeries = new double[2];
            double[] ySeries = new double[2];
            xSeries[0] = peakModel.getRetentionTimeAtPeakMaximumByInflectionPoints();
            ySeries[0] = includeBackground ? (double)peakModel.getBackgroundAbundance(peakModel.getRetentionTimeAtPeakMaximumByInflectionPoints()) : 0.0;
            try {
                IPoint intersection = Equations.calculateIntersection((LinearEquation)peakModel.getIncreasingInflectionPointEquation(), (LinearEquation)peakModel.getDecreasingInflectionPointEquation());
                xSeries[1] = intersection.getX();
                ySeries[1] = includeBackground ? intersection.getY() + (double)peakModel.getBackgroundAbundance((int)intersection.getX()) : intersection.getY();
            }
            catch (SolverException solverException) {}
            series = new Series(xSeries, ySeries, "Peak Perpendicular");
        }
        return series;
    }

    public static ISeries convertPeakWidthByInflectionPoints(IPeakMSD peak, boolean includeBackground, float height, Sign sign) {
        Series series = null;
        if (peak != null) {
            IPeakModelMSD peakModel = peak.getPeakModel();
            double[] xSeries = new double[2];
            double[] ySeries = new double[2];
            LinearEquation percentageHeightBaseline = peakModel.getPercentageHeightBaselineEquation(height);
            if (percentageHeightBaseline != null) {
                try {
                    IPoint p1 = Equations.calculateIntersection((LinearEquation)peakModel.getIncreasingInflectionPointEquation(), (LinearEquation)percentageHeightBaseline);
                    IPoint p2 = Equations.calculateIntersection((LinearEquation)peakModel.getDecreasingInflectionPointEquation(), (LinearEquation)percentageHeightBaseline);
                    double startRetentionTime = peakModel.getStartRetentionTime();
                    double x = p1.getX() < startRetentionTime ? startRetentionTime : p1.getX();
                    xSeries[0] = p1.getX();
                    ySeries[0] = includeBackground ? p1.getY() + (double)peakModel.getBackgroundAbundance((int)x) : p1.getY();
                    double stopRetentionTime = peakModel.getStopRetentionTime();
                    x = p2.getX() > stopRetentionTime ? stopRetentionTime : p2.getX();
                    xSeries[1] = p2.getX();
                    ySeries[1] = includeBackground ? p2.getY() + (double)peakModel.getBackgroundAbundance((int)x) : p2.getY();
                }
                catch (SolverException solverException) {}
            }
            String id = "Peak Width at " + height * 100.0f + "%";
            series = new Series(xSeries, ySeries, id);
        }
        return series;
    }

    private static ISeries getSelectedAccurateIonAsSeries(double ion, IChromatogramMSD chromatogram, ScanRange scanRange, Sign sign, int precision) {
        assert (chromatogram != null) : "Chromatogram must not be null.";
        assert (sign != null) : "Sign must not be null.";
        int scans = scanRange.getWidth();
        int startScan = scanRange.getStartScan();
        int stopScan = scanRange.getStopScan();
        double[] xSeries = new double[scans];
        double[] ySeries = new double[scans];
        int x = 0;
        int y = 0;
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
            double retentionTime = massSpectrum.getRetentionTime();
            double abundance = 0.0;
            try {
                abundance = massSpectrum.getIon(ion, precision).getAbundance();
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            if (sign == Sign.NEGATIVE) {
                abundance *= -1.0;
            }
            xSeries[x++] = retentionTime;
            ySeries[y++] = abundance;
            ++scan;
        }
        Series series = new Series(xSeries, ySeries, "accurate ion: " + AbstractIon.getIon((double)ion, (int)precision));
        return series;
    }

    private static ISeries getSelectedExactIonAsSeries(double ion, IChromatogramMSD chromatogram, ScanRange scanRange, Sign sign) {
        assert (chromatogram != null) : "Chromatogram must not be null.";
        assert (sign != null) : "Sign must not be null.";
        int scans = scanRange.getWidth();
        int startScan = scanRange.getStartScan();
        int stopScan = scanRange.getStopScan();
        double[] xSeries = new double[scans];
        double[] ySeries = new double[scans];
        int x = 0;
        int y = 0;
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
            double retentionTime = massSpectrum.getRetentionTime();
            double abundance = 0.0;
            try {
                abundance = massSpectrum.getIon(ion).getAbundance();
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            if (sign == Sign.NEGATIVE) {
                abundance *= -1.0;
            }
            xSeries[x++] = retentionTime;
            ySeries[y++] = abundance;
            ++scan;
        }
        Series series = new Series(xSeries, ySeries, "exact ion: " + ion);
        return series;
    }

    private static ISeries getSelectedIonTransitionAsSeries(IIonTransition ionTransition, IChromatogramMSD chromatogram, ScanRange scanRange) {
        assert (ionTransition != null) : "IonTransition must not be null.";
        assert (chromatogram != null) : "Chromatogram must not be null.";
        int scans = scanRange.getWidth();
        int startScan = scanRange.getStartScan();
        int stopScan = scanRange.getStopScan();
        double[] xSeries = new double[scans];
        double[] ySeries = new double[scans];
        int x = 0;
        int y = 0;
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
            double retentionTime = massSpectrum.getRetentionTime();
            double abundance = 0.0;
            for (IIon ion : massSpectrum.getIons()) {
                IIonTransition transition = ion.getIonTransition();
                if (transition == null || !transition.equals(ionTransition)) continue;
                abundance = ion.getAbundance();
            }
            xSeries[x++] = retentionTime;
            ySeries[y++] = abundance;
            ++scan;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ionTransition.getQ1Ion());
        builder.append(" > ");
        builder.append(ionTransition.getQ3Ion());
        builder.append(" @");
        builder.append(ionTransition.getCollisionEnergy());
        builder.append(" r");
        builder.append(ionTransition.getQ1Resolution());
        builder.append(":");
        builder.append(ionTransition.getQ3Resolution());
        Series series = new Series(xSeries, ySeries, builder.toString());
        return series;
    }

    private static ISeries getSelectedIonAsSeries(int ion, int magnification, IExtractedIonSignals signals, Sign sign) {
        assert (signals != null) : "IExtractedIonSignals must not be null.";
        assert (sign != null) : "Sign must not be null.";
        int scans = signals.size();
        double[] xSeries = new double[scans];
        double[] ySeries = new double[scans];
        int x = 0;
        int y = 0;
        for (IExtractedIonSignal signal : signals.getExtractedIonSignals()) {
            double retentionTime = signal.getRetentionTime();
            double abundance = signal.getAbundance(ion) * (float)magnification;
            if (sign == Sign.NEGATIVE) {
                abundance *= -1.0;
            }
            xSeries[x++] = retentionTime;
            ySeries[y++] = abundance;
        }
        Series series = new Series(xSeries, ySeries, "ion: " + ion + " x" + magnification);
        return series;
    }

    private static ISeries getSelectedAccurateIonsAsCombinedSeries(IMarkedIons selectedIons, IChromatogramMSD chromatogram, ScanRange scanRange, Sign sign, int precision) {
        assert (selectedIons != null) : "IMarkedIons must not be null.";
        assert (chromatogram != null) : "Chromatogram must not be null.";
        assert (sign != null) : "Sign must not be null.";
        int scans = scanRange.getWidth();
        int startScan = scanRange.getStartScan();
        int stopScan = scanRange.getStopScan();
        double[] xSeries = new double[scans];
        double[] ySeries = new double[scans];
        int x = 0;
        int y = 0;
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
            double retentionTime = massSpectrum.getRetentionTime();
            double abundance = 0.0;
            for (IMarkedIon markedIon : selectedIons) {
                try {
                    abundance += (double)massSpectrum.getIon(markedIon.getIon(), precision).getAbundance();
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
            }
            if (sign == Sign.NEGATIVE) {
                abundance *= -1.0;
            }
            xSeries[x++] = retentionTime;
            ySeries[y++] = abundance;
            ++scan;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("selected accurate ion: ");
        for (IMarkedIon markedIon : selectedIons) {
            builder.append(AbstractIon.getIon((double)markedIon.getIon(), (int)precision));
            builder.append(" ");
        }
        Series series = new Series(xSeries, ySeries, builder.toString());
        return series;
    }

    private static ISeries getSelectedExactIonsAsCombinedSeries(IMarkedIons selectedIons, IChromatogramMSD chromatogram, ScanRange scanRange, Sign sign) {
        assert (selectedIons != null) : "IMarkedIons must not be null.";
        assert (chromatogram != null) : "Chromatogram must not be null.";
        assert (sign != null) : "Sign must not be null.";
        int scans = scanRange.getWidth();
        int startScan = scanRange.getStartScan();
        int stopScan = scanRange.getStopScan();
        double[] xSeries = new double[scans];
        double[] ySeries = new double[scans];
        int x = 0;
        int y = 0;
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
            double retentionTime = massSpectrum.getRetentionTime();
            double abundance = 0.0;
            for (IMarkedIon markedIon : selectedIons) {
                try {
                    abundance += (double)massSpectrum.getIon(markedIon.getIon()).getAbundance();
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
            }
            if (sign == Sign.NEGATIVE) {
                abundance *= -1.0;
            }
            xSeries[x++] = retentionTime;
            ySeries[y++] = abundance;
            ++scan;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("selected exact ion: ");
        for (IMarkedIon markedIon : selectedIons) {
            builder.append(markedIon.getIon());
            builder.append(" ");
        }
        Series series = new Series(xSeries, ySeries, builder.toString());
        return series;
    }

    private static ISeries getSelectedIonsAsCombinedSeries(IMarkedIons selectedIons, IExtractedIonSignals signals, Sign sign) {
        assert (selectedIons != null) : "IMarkedIons must not be null.";
        assert (signals != null) : "IExtractedIonSignals must not be null.";
        assert (sign != null) : "Sign must not be null.";
        int scans = signals.size();
        double[] xSeries = new double[scans];
        double[] ySeries = new double[scans];
        int x = 0;
        int y = 0;
        for (IExtractedIonSignal signal : signals.getExtractedIonSignals()) {
            double retentionTime = signal.getRetentionTime();
            double abundance = 0.0;
            for (IMarkedIon markedIon : selectedIons) {
                int ion = AbstractIon.getIon((double)markedIon.getIon());
                abundance += (double)(signal.getAbundance(ion) * (float)markedIon.getMagnification());
            }
            if (sign == Sign.NEGATIVE) {
                abundance *= -1.0;
            }
            xSeries[x++] = retentionTime;
            ySeries[y++] = abundance;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("selected ion: ");
        Iterator iterator = selectedIons.getIonsNominal().iterator();
        while (iterator.hasNext()) {
            int ion = (Integer)iterator.next();
            builder.append(ion);
            builder.append(" ");
        }
        Series series = new Series(xSeries, ySeries, builder.toString());
        return series;
    }

    private static ISeries getIonSeriesWithoutExcludedIons(IMarkedIons excludedIons, IExtractedIonSignals signals, Sign sign) {
        assert (excludedIons != null) : "IMarkedIons must not be null.";
        assert (signals != null) : "IExtractedIonSignals must not be null.";
        assert (sign != null) : "Sign must not be null.";
        int scans = signals.size();
        double[] xSeries = new double[scans];
        double[] ySeries = new double[scans];
        int x = 0;
        int y = 0;
        for (IExtractedIonSignal signal : signals.getExtractedIonSignals()) {
            double retentionTime = signal.getRetentionTime();
            double abundance = signal.getTotalSignal();
            Iterator iterator = excludedIons.getIonsNominal().iterator();
            while (iterator.hasNext()) {
                int ion = (Integer)iterator.next();
                abundance -= (double)signal.getAbundance(ion);
            }
            if (sign == Sign.NEGATIVE) {
                abundance *= -1.0;
            }
            xSeries[x++] = retentionTime;
            ySeries[y++] = abundance;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("all ion except: ");
        Iterator iterator = excludedIons.getIonsNominal().iterator();
        while (iterator.hasNext()) {
            int ion = (Integer)iterator.next();
            builder.append(ion);
            builder.append(" ");
        }
        Series series = new Series(xSeries, ySeries, builder.toString());
        return series;
    }
}

