/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.ScanMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScanMassSpectrumUIWithLabel
extends Composite
implements IChromatogramSelectionMSDUpdateNotifier {
    private ScanMassSpectrumUI massSpectrumUI;
    private Label label;
    private IScanMSD massSpectrum;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0##");
    private MassValueDisplayPrecision massValueDisplayPrecision;

    public ScanMassSpectrumUIWithLabel(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite labelbar = new Composite(composite, 4);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        labelbar.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        labelbar.setLayoutData((Object)gridData);
        this.label = new Label(labelbar, 0);
        this.label.setText("");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.label.setLayoutData((Object)gridData);
        this.massSpectrumUI = new ScanMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.massSpectrumUI.setLayoutData(gridData);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (chromatogramSelection != null && this.massSpectrum != chromatogramSelection.getSelectedScan()) {
            this.massSpectrum = chromatogramSelection.getSelectedScan();
            this.setMassSpectrumLabel(this.massSpectrum);
            this.massSpectrumUI.update(chromatogramSelection, forceReload);
        }
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum) {
        StringBuilder builder = new StringBuilder();
        builder.append("Scan: ");
        builder.append(massSpectrum.getScanNumber());
        builder.append(" | ");
        builder.append("RT: ");
        builder.append(this.decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0));
        builder.append(" | ");
        builder.append("RI: ");
        if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
            builder.append(Integer.toString((int)massSpectrum.getRetentionIndex()));
        } else {
            builder.append(this.decimalFormat.format(massSpectrum.getRetentionIndex()));
        }
        builder.append(" | ");
        if (massSpectrum instanceof IVendorMassSpectrum) {
            IVendorMassSpectrum actualMassSpectrum = (IVendorMassSpectrum)massSpectrum;
            builder.append("Detector: MS");
            builder.append(actualMassSpectrum.getMassSpectrometer());
            builder.append(" | ");
            builder.append("Type: ");
            builder.append(actualMassSpectrum.getMassSpectrumTypeDescription());
            builder.append(" | ");
        }
        builder.append("Signal: ");
        builder.append((int)massSpectrum.getTotalSignal());
        this.label.setText(builder.toString());
    }
}

