/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.notifier;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ICombinedIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.notifier.DynamicIntegrationResultUpdateNotifier;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class IntegrationResultUpdateNotifier {
    private static DynamicIntegrationResultUpdateNotifier dynamicUpdateNotifier;

    private IntegrationResultUpdateNotifier() {
    }

    public static void fireUpdateChange(ICombinedIntegrationResult combinedIntegrationResult) {
        IntegrationResultUpdateNotifier.validateDynamicUpdateNotifier();
        dynamicUpdateNotifier.update(combinedIntegrationResult);
    }

    public static void fireUpdateChange(IChromatogramIntegrationResults chromatogramIntegrationResults) {
        IntegrationResultUpdateNotifier.validateDynamicUpdateNotifier();
        dynamicUpdateNotifier.update(chromatogramIntegrationResults);
    }

    public static void fireUpdateChange(IPeakIntegrationResults peakIntegrationResults) {
        IntegrationResultUpdateNotifier.validateDynamicUpdateNotifier();
        dynamicUpdateNotifier.update(peakIntegrationResults);
    }

    private static void validateDynamicUpdateNotifier() {
        if (dynamicUpdateNotifier == null) {
            Bundle bundle = FrameworkUtil.getBundle(ChromatogramSelectionMSDUpdateNotifier.class);
            BundleContext bundleContext = bundle.getBundleContext();
            IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            eclipseContext.set(Logger.class, null);
            dynamicUpdateNotifier = (DynamicIntegrationResultUpdateNotifier)ContextInjectionFactory.make(DynamicIntegrationResultUpdateNotifier.class, (IEclipseContext)eclipseContext);
        }
    }
}

