/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.support;

import java.util.List;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.swt.graphics.Color;

public class ColorScheme
implements IColorScheme {
    private int index = 0;
    private List<Color> colors;

    public ColorScheme(List<Color> colors) {
        this.colors = colors;
    }

    @Override
    public Color getColor(int i) {
        if (i >= 0 && i < this.colors.size()) {
            return this.colors.get(i);
        }
        if (this.colors.size() == 0) {
            return null;
        }
        return this.colors.get(0);
    }

    @Override
    public Color getNextColor() {
        ++this.index;
        this.validatePosition();
        return this.colors.get(this.index);
    }

    @Override
    public Color getPreviousColor() {
        --this.index;
        this.validatePosition();
        return this.colors.get(this.index);
    }

    @Override
    public int size() {
        return this.colors.size();
    }

    private void validatePosition() {
        if (this.index < 0) {
            this.index = this.size() - 1;
        } else if (this.index >= this.size()) {
            this.index = 0;
        }
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public Color getColor() {
        this.validatePosition();
        return this.colors.get(this.index);
    }

    @Override
    public void incrementColor() {
        ++this.index;
        this.validatePosition();
    }
}

