/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.svd;

import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class SmartRotatorUpdate {
    DenseMatrix64F R;
    int[] mod = new int[1];

    public DenseMatrix64F getR() {
        return this.R;
    }

    public void init(DenseMatrix64F R) {
        this.R = R;
        CommonOps.setIdentity(R);
        int a = Math.min(R.numRows, R.numCols);
        if (this.mod.length < a) {
            this.mod = new int[a];
        }
        int i = 0;
        while (i < a) {
            this.mod[i] = i;
            ++i;
        }
    }

    public void update(int rowA, int rowB, double c, double s) {
        int l;
        this.mod[rowA] = l = Math.max(this.mod[rowA], this.mod[rowB]);
        this.mod[rowB] = l;
        int indexA = rowA * this.R.numCols;
        int indexB = rowB * this.R.numCols;
        int i = 0;
        while (i < l) {
            double a = this.R.data[indexA];
            double b = this.R.data[indexB];
            this.R.data[indexA] = c * a + s * b;
            this.R.data[indexB] = -s * a + c * b;
            ++i;
            ++indexA;
            ++indexB;
        }
    }
}

