/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.converter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.peak.AbstractPeakImportConverter;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.peak.PeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.internal.converter.SpecificationValidator;
import org.eclipse.chemclipse.msd.converter.supplier.matlab.parafac.io.MatlabParafacPeakReader;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MatlabParafacPeakImportConverter
extends AbstractPeakImportConverter {
    private static final Logger logger = Logger.getLogger(MatlabParafacPeakImportConverter.class);

    public IPeakImportConverterProcessingInfo convert(File file, IProgressMonitor monitor) {
        PeakImportConverterProcessingInfo processingInfo = new PeakImportConverterProcessingInfo();
        try {
            super.validate(file);
            file = SpecificationValidator.validateSpecification(file);
            MatlabParafacPeakReader peakReader = new MatlabParafacPeakReader();
            IPeakImportConverterProcessingInfo processingInfoReader = peakReader.read(file, monitor);
            processingInfo.addMessages((IProcessingInfo)processingInfoReader);
            try {
                processingInfo.setPeaks(processingInfoReader.getPeaks());
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peaks", "The given file was not found: " + file.getAbsolutePath());
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (FileIsNotReadableException e) {
            logger.warn((Object)e);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peaks", "The given file is not readable: " + file.getAbsolutePath());
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (FileIsEmptyException e) {
            logger.warn((Object)e);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peaks", "The given file is empty: " + file.getAbsolutePath());
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        catch (IOException e) {
            logger.warn((Object)e);
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Import Peaks", "There has gone something wrong reading the file: " + file.getAbsolutePath());
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }
}

