/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabaseProxy;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.QuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.QuantDatabaseProxy;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.NoQuantitationTableAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.QuantitationTableAlreadyExistsException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.io.QuantDatabaseReader;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.io.QuantDatabaseWriter;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.settings.ApplicationSettings;

public class QuantDatabases {
    public static final String IDENTIFIER_QUANTITATION = "org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse";
    private static final Logger logger = Logger.getLogger(QuantDatabases.class);
    private static final Map<String, IQuantDatabase> databases = new HashMap<String, IQuantDatabase>();

    private QuantDatabases() {
    }

    public static void persistDatabases() {
        String storagePath = QuantDatabases.getStoragePath().getAbsolutePath();
        for (Map.Entry<String, IQuantDatabase> entry : databases.entrySet()) {
            try {
                File file = new File(String.valueOf(storagePath) + File.separator + entry.getKey());
                IQuantDatabase quantDatabase = entry.getValue();
                QuantDatabaseWriter.write(quantDatabase, file);
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
    }

    public static IQuantDatabase getQuantDatabase() throws NoQuantitationTableAvailableException {
        String databaseName = PreferenceSupplier.getSelectedQuantitationTable();
        return QuantDatabases.getQuantDatabase(databaseName);
    }

    public static IQuantDatabase getQuantDatabase(String databaseName) throws NoQuantitationTableAvailableException {
        IQuantDatabase quantDatabase = databases.get(databaseName);
        if (quantDatabase == null) {
            try {
                File file = new File(QuantDatabases.getStoragePath() + File.separator + databaseName);
                quantDatabase = QuantDatabaseReader.read(file);
            }
            catch (Exception e) {
                quantDatabase = new QuantDatabase();
                logger.warn((Object)e);
            }
            databases.put(databaseName, quantDatabase);
        }
        return quantDatabase;
    }

    public static List<String> getDatabaseNames() throws NoQuantitationTableAvailableException {
        ArrayList<String> databaseNames = new ArrayList<String>();
        File storageDirectory = QuantDatabases.getStoragePath();
        File[] fileArray = storageDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                databaseNames.add(file.getName());
            }
            ++n2;
        }
        return databaseNames;
    }

    public static List<IQuantDatabaseProxy> listAvailableDatabaseProxies() throws NoQuantitationTableAvailableException {
        ArrayList<IQuantDatabaseProxy> databaseProxies = new ArrayList<IQuantDatabaseProxy>();
        List<String> databaseNames = QuantDatabases.getDatabaseNames();
        for (String databaseName : databaseNames) {
            databaseProxies.add(new QuantDatabaseProxy(databaseName));
        }
        return databaseProxies;
    }

    public static void createDatabase(String databaseName) throws QuantitationTableAlreadyExistsException {
        File storageDirectory = QuantDatabases.getStoragePath();
        File databaseNew = new File(String.valueOf(storageDirectory.getAbsolutePath()) + File.separator + databaseName);
        if (databaseNew.exists()) {
            throw new QuantitationTableAlreadyExistsException();
        }
        try {
            databaseNew.createNewFile();
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    public static boolean deleteDatabase(IQuantDatabaseProxy quantDatabaseProxy) {
        String databaseName = quantDatabaseProxy.getDatabaseName();
        String databaseUrl = quantDatabaseProxy.getDatabaseUrl();
        databases.remove(databaseName);
        File database = new File(String.valueOf(databaseUrl) + File.separator + databaseUrl);
        return database.delete();
    }

    public static void cleanStoragePath() {
        File directory = QuantDatabases.getStoragePath();
        QuantDatabases.deleteFiles(directory);
    }

    public static File getStoragePath() {
        File file = new File(String.valueOf(ApplicationSettings.getSettingsDirectory().getAbsolutePath()) + File.separator + IDENTIFIER_QUANTITATION);
        if (!file.exists() && !file.mkdirs()) {
            logger.warn((Object)("The quantitation directory could not be created: " + file.getAbsolutePath()));
        }
        return file;
    }

    private static void deleteFiles(File directory) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                QuantDatabases.deleteFiles(file);
            } else if (!file.delete()) {
                logger.warn((Object)("The file " + file + "could not be deleted."));
            }
            ++n2;
        }
        if (!directory.delete()) {
            logger.warn((Object)("The directory " + directory + "could not be deleted."));
        }
    }
}

