/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.command.AbstractContextFreeCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.ITraversalStrategy;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.AbstractSelectionCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;

public abstract class MoveSelectionCommandHandler<T extends MoveSelectionCommand>
implements ILayerCommandHandler<T> {
    protected final SelectionLayer selectionLayer;
    protected final ITraversalStrategy horizontalTraversalStrategy;
    protected final ITraversalStrategy verticalTraversalStrategy;

    public MoveSelectionCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, ITraversalStrategy.AXIS_TRAVERSAL_STRATEGY);
    }

    public MoveSelectionCommandHandler(SelectionLayer selectionLayer, ITraversalStrategy traversalStrategy) {
        this(selectionLayer, traversalStrategy, traversalStrategy);
    }

    public MoveSelectionCommandHandler(SelectionLayer selectionLayer, ITraversalStrategy horizontalTraversalStrategy, ITraversalStrategy verticalTraversalStrategy) {
        if (horizontalTraversalStrategy == null || verticalTraversalStrategy == null) {
            throw new IllegalArgumentException("You need to specify an ITraversalStrategy!");
        }
        this.selectionLayer = selectionLayer;
        this.horizontalTraversalStrategy = horizontalTraversalStrategy;
        this.verticalTraversalStrategy = verticalTraversalStrategy;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, T command) {
        if (((AbstractContextFreeCommand)command).convertToTargetLayer(this.selectionLayer)) {
            this.moveSelection(((MoveSelectionCommand)command).getDirection(), this.getTraversalStrategy(command), ((AbstractSelectionCommand)command).isShiftMask(), ((AbstractSelectionCommand)command).isControlMask());
            return true;
        }
        return false;
    }

    protected ITraversalStrategy getTraversalStrategy(T command) {
        if (SelectionLayer.MoveDirectionEnum.DOWN.equals((Object)((MoveSelectionCommand)command).getDirection()) || SelectionLayer.MoveDirectionEnum.UP.equals((Object)((MoveSelectionCommand)command).getDirection())) {
            return this.getTraversalStrategy(command, this.verticalTraversalStrategy);
        }
        if (SelectionLayer.MoveDirectionEnum.LEFT.equals((Object)((MoveSelectionCommand)command).getDirection()) || SelectionLayer.MoveDirectionEnum.RIGHT.equals((Object)((MoveSelectionCommand)command).getDirection())) {
            return this.getTraversalStrategy(command, this.horizontalTraversalStrategy);
        }
        return null;
    }

    private ITraversalStrategy getTraversalStrategy(T command, final ITraversalStrategy baseTraversalStrategy) {
        ITraversalStrategy result = ((MoveSelectionCommand)command).getTraversalStrategy();
        if (result == null) {
            result = ((MoveSelectionCommand)command).getStepSize() != null ? new ITraversalStrategy((MoveSelectionCommand)command){
                private final /* synthetic */ MoveSelectionCommand val$command;
                {
                    this.val$command = moveSelectionCommand;
                }

                @Override
                public ITraversalStrategy.TraversalScope getTraversalScope() {
                    return baseTraversalStrategy.getTraversalScope();
                }

                @Override
                public boolean isCycle() {
                    return baseTraversalStrategy.isCycle();
                }

                @Override
                public int getStepCount() {
                    return this.val$command.getStepSize();
                }

                @Override
                public boolean isValidTarget(ILayerCell from, ILayerCell to) {
                    return baseTraversalStrategy.isValidTarget(from, to);
                }
            } : baseTraversalStrategy;
        }
        return result;
    }

    protected void moveSelection(SelectionLayer.MoveDirectionEnum moveDirection, ITraversalStrategy traversalStrategy, boolean withShiftMask, boolean withControlMask) {
        switch (moveDirection) {
            case UP: {
                this.moveLastSelectedUp(traversalStrategy, withShiftMask, withControlMask);
                break;
            }
            case DOWN: {
                this.moveLastSelectedDown(traversalStrategy, withShiftMask, withControlMask);
                break;
            }
            case LEFT: {
                this.moveLastSelectedLeft(traversalStrategy, withShiftMask, withControlMask);
                break;
            }
            case RIGHT: {
                this.moveLastSelectedRight(traversalStrategy, withShiftMask, withControlMask);
                break;
            }
        }
    }

    protected abstract void moveLastSelectedRight(ITraversalStrategy var1, boolean var2, boolean var3);

    protected abstract void moveLastSelectedLeft(ITraversalStrategy var1, boolean var2, boolean var3);

    protected abstract void moveLastSelectedUp(ITraversalStrategy var1, boolean var2, boolean var3);

    protected abstract void moveLastSelectedDown(ITraversalStrategy var1, boolean var2, boolean var3);
}

