/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.polynomials;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class PolynomialFunction
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction,
Serializable {
    private static final long serialVersionUID = -7726511984200295583L;
    private final double[] coefficients;

    /*
     * Unable to fully structure code
     */
    public PolynomialFunction(double[] c) throws NullArgumentException, NoDataException {
        super();
        MathUtils.checkNotNull(c);
        n = c.length;
        if (n != 0) ** GOTO lbl7
        throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
lbl-1000:
        // 1 sources

        {
            --n;
lbl7:
            // 2 sources

            ** while (n > 1 && c[n - 1] == 0.0)
        }
lbl8:
        // 1 sources

        this.coefficients = new double[n];
        System.arraycopy(c, 0, this.coefficients, 0, n);
    }

    @Override
    public double value(double x) {
        return PolynomialFunction.evaluate(this.coefficients, x);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    protected static double evaluate(double[] coefficients, double argument) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull(coefficients);
        int n = coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        double result = coefficients[n - 1];
        int j = n - 2;
        while (j >= 0) {
            result = argument * result + coefficients[j];
            --j;
        }
        return result;
    }

    @Override
    public DerivativeStructure value(DerivativeStructure t) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull(this.coefficients);
        int n = this.coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        DerivativeStructure result = new DerivativeStructure(t.getFreeParameters(), t.getOrder(), this.coefficients[n - 1]);
        int j = n - 2;
        while (j >= 0) {
            result = result.multiply(t).add(this.coefficients[j]);
            --j;
        }
        return result;
    }

    public PolynomialFunction add(PolynomialFunction p) {
        int lowLength = FastMath.min(this.coefficients.length, p.coefficients.length);
        int highLength = FastMath.max(this.coefficients.length, p.coefficients.length);
        double[] newCoefficients = new double[highLength];
        int i = 0;
        while (i < lowLength) {
            newCoefficients[i] = this.coefficients[i] + p.coefficients[i];
            ++i;
        }
        System.arraycopy(this.coefficients.length < p.coefficients.length ? p.coefficients : this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction subtract(PolynomialFunction p) {
        int lowLength = FastMath.min(this.coefficients.length, p.coefficients.length);
        int highLength = FastMath.max(this.coefficients.length, p.coefficients.length);
        double[] newCoefficients = new double[highLength];
        int i = 0;
        while (i < lowLength) {
            newCoefficients[i] = this.coefficients[i] - p.coefficients[i];
            ++i;
        }
        if (this.coefficients.length < p.coefficients.length) {
            i = lowLength;
            while (i < highLength) {
                newCoefficients[i] = -p.coefficients[i];
                ++i;
            }
        } else {
            System.arraycopy(this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        }
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction negate() {
        double[] newCoefficients = new double[this.coefficients.length];
        int i = 0;
        while (i < this.coefficients.length) {
            newCoefficients[i] = -this.coefficients[i];
            ++i;
        }
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction multiply(PolynomialFunction p) {
        double[] newCoefficients = new double[this.coefficients.length + p.coefficients.length - 1];
        int i = 0;
        while (i < newCoefficients.length) {
            newCoefficients[i] = 0.0;
            int j = FastMath.max(0, i + 1 - p.coefficients.length);
            while (j < FastMath.min(this.coefficients.length, i + 1)) {
                int n = i;
                newCoefficients[n] = newCoefficients[n] + this.coefficients[j] * p.coefficients[i - j];
                ++j;
            }
            ++i;
        }
        return new PolynomialFunction(newCoefficients);
    }

    protected static double[] differentiate(double[] coefficients) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull(coefficients);
        int n = coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        if (n == 1) {
            return new double[]{0.0};
        }
        double[] result = new double[n - 1];
        int i = n - 1;
        while (i > 0) {
            result[i - 1] = (double)i * coefficients[i];
            --i;
        }
        return result;
    }

    public PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    @Override
    public UnivariateFunction derivative() {
        return this.polynomialDerivative();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.coefficients[0] == 0.0) {
            if (this.coefficients.length == 1) {
                return "0";
            }
        } else {
            s.append(PolynomialFunction.toString(this.coefficients[0]));
        }
        int i = 1;
        while (i < this.coefficients.length) {
            if (this.coefficients[i] != 0.0) {
                if (s.length() > 0) {
                    if (this.coefficients[i] < 0.0) {
                        s.append(" - ");
                    } else {
                        s.append(" + ");
                    }
                } else if (this.coefficients[i] < 0.0) {
                    s.append("-");
                }
                double absAi = FastMath.abs(this.coefficients[i]);
                if (absAi - 1.0 != 0.0) {
                    s.append(PolynomialFunction.toString(absAi));
                    s.append(' ');
                }
                s.append("x");
                if (i > 1) {
                    s.append('^');
                    s.append(Integer.toString(i));
                }
            }
            ++i;
        }
        return s.toString();
    }

    private static String toString(double coeff) {
        String c = Double.toString(coeff);
        if (c.endsWith(".0")) {
            return c.substring(0, c.length() - 2);
        }
        return c;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolynomialFunction)) {
            return false;
        }
        PolynomialFunction other = (PolynomialFunction)obj;
        return Arrays.equals(this.coefficients, other.coefficients);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double[] gradient(double x, double ... parameters) {
            double[] gradient = new double[parameters.length];
            double xn = 1.0;
            int i = 0;
            while (i < parameters.length) {
                gradient[i] = xn;
                xn *= x;
                ++i;
            }
            return gradient;
        }

        @Override
        public double value(double x, double ... parameters) throws NoDataException {
            return PolynomialFunction.evaluate(parameters, x);
        }
    }
}

