/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MemberActionFilter
implements IActionFilter {
    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals("MemberActionFilter") && target instanceof IMember) {
            IMember member = (IMember)target;
            if (value.equals("isAbstract")) {
                try {
                    return Flags.isAbstract((int)member.getFlags());
                }
                catch (JavaModelException javaModelException) {}
            }
            if (value.equals("isRemote")) {
                IEditorPart part;
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null && (part = page.getActiveEditor()) != null) {
                    Object adapter = Platform.getAdapterManager().getAdapter((Object)part.getEditorInput(), "org.eclipse.team.core.history.IFileRevision");
                    return adapter != null;
                }
                return false;
            }
            if (value.equals("isInterface")) {
                IType type = null;
                type = member.getElementType() == 7 ? (IType)member : member.getDeclaringType();
                try {
                    return type != null && type.isInterface();
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            if (value.equals("isConstructor")) {
                IMethod method = null;
                if (member.getElementType() == 9) {
                    method = (IMethod)member;
                    try {
                        return method.isConstructor();
                    }
                    catch (JavaModelException e) {
                        JDIDebugUIPlugin.log(e);
                        return false;
                    }
                }
            }
            if (value.equals("isValidField")) {
                try {
                    int flags = member.getFlags();
                    return member.getElementType() == 8 & (!Flags.isFinal((int)flags) & !(Flags.isStatic((int)flags) & Flags.isFinal((int)flags)));
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                    return false;
                }
            }
            if (value.equals("isInstanceRetrievalAvailable")) {
                IDebugTarget adapter;
                IAdaptable adapt = DebugUITools.getDebugContext();
                if (adapt != null && (adapter = (IDebugTarget)adapt.getAdapter(IDebugTarget.class)) != null && adapter instanceof IJavaDebugTarget) {
                    IJavaDebugTarget dtarget = (IJavaDebugTarget)adapter;
                    return dtarget.supportsInstanceRetrieval();
                }
                return false;
            }
        }
        return false;
    }
}

