/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.toolbar;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GraphConfigPage {
    private IXYGraph xyGraph;
    private Text titleText;
    private Font titleFont;
    private ColorSelector titleColorSelector;
    private ColorSelector plotAreaColorSelector;
    private Button showTitle;
    private Button showLegend;
    private Button showPlotAreaBorder;
    private Button transparent;

    public GraphConfigPage(IXYGraph xyGraph) {
        this((XYGraph)xyGraph);
    }

    @Deprecated
    public GraphConfigPage(XYGraph xyGraph) {
        this.xyGraph = xyGraph;
        this.titleFont = xyGraph.getTitleFont();
    }

    public void createPage(final Composite composite) {
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Title: ");
        titleLabel.setLayoutData((Object)labelGd);
        this.titleText = new Text(composite, 2052);
        this.titleText.setText(this.xyGraph.getTitle());
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.titleText.setLayoutData((Object)gd);
        final Label fontLabel = new Label(composite, 0);
        fontLabel.setText("Title Font: " + (this.titleFont == null ? "System Default" : this.titleFont.getFontData()[0].getName()));
        fontLabel.setFont(this.titleFont);
        fontLabel.setForeground(this.xyGraph.getTitleColor());
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        fontLabel.setLayoutData((Object)labelGd);
        Button fontButton = new Button(composite, 8);
        fontButton.setText("Change...");
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        fontButton.setLayoutData((Object)gd);
        fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontData fontData;
                FontDialog fontDialog = new FontDialog(composite.getShell());
                if (GraphConfigPage.this.titleFont != null) {
                    fontDialog.setFontList(GraphConfigPage.this.titleFont.getFontData());
                }
                if ((fontData = fontDialog.open()) != null) {
                    GraphConfigPage.this.titleFont = XYGraphMediaFactory.getInstance().getFont(fontData);
                    fontLabel.setFont(GraphConfigPage.this.titleFont);
                    fontLabel.setText("Title Font: " + fontData.getName());
                    composite.getShell().layout(true, true);
                }
            }
        });
        Label colorLabel = new Label(composite, 0);
        colorLabel.setText("Title Color:");
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        colorLabel.setLayoutData((Object)labelGd);
        this.titleColorSelector = new ColorSelector(composite);
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.titleColorSelector.getButton().setLayoutData((Object)gd);
        this.titleColorSelector.setColorValue(this.xyGraph.getTitleColor().getRGB());
        this.titleColorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                fontLabel.setForeground(XYGraphMediaFactory.getInstance().getColor(GraphConfigPage.this.titleColorSelector.getColorValue()));
            }
        });
        Label plotAreaColorLabel = new Label(composite, 0);
        plotAreaColorLabel.setText("Plot Area Background Color:");
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        plotAreaColorLabel.setLayoutData((Object)labelGd);
        this.plotAreaColorSelector = new ColorSelector(composite);
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.plotAreaColorSelector.getButton().setLayoutData((Object)gd);
        this.plotAreaColorSelector.setColorValue(this.xyGraph.getPlotArea().getBackgroundColor().getRGB());
        this.showTitle = new Button(composite, 32);
        this.showTitle.setSelection(this.xyGraph.isShowTitle());
        this.showTitle.setText("Show Title");
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        this.showTitle.setLayoutData((Object)gd);
        this.showLegend = new Button(composite, 32);
        this.showLegend.setSelection(this.xyGraph.isShowLegend());
        this.showLegend.setText("Show Legend");
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        this.showLegend.setLayoutData((Object)gd);
        this.showPlotAreaBorder = new Button(composite, 32);
        this.showPlotAreaBorder.setSelection(this.xyGraph.getPlotArea().isShowBorder());
        this.showPlotAreaBorder.setText("Show Plot Area Border");
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        this.showPlotAreaBorder.setLayoutData((Object)gd);
        this.transparent = new Button(composite, 32);
        this.transparent.setSelection(this.xyGraph.isTransparent());
        this.transparent.setText("Transparent");
        gd = new GridData(1, 0x1000000, false, false, 3, 1);
        this.transparent.setLayoutData((Object)gd);
    }

    public void applyChanges() {
        this.xyGraph.setTitle(this.titleText.getText());
        this.xyGraph.setTitleFont(this.titleFont);
        this.xyGraph.setTitleColor(XYGraphMediaFactory.getInstance().getColor(this.titleColorSelector.getColorValue()));
        this.xyGraph.getPlotArea().setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(this.plotAreaColorSelector.getColorValue()));
        this.xyGraph.setShowTitle(this.showTitle.getSelection());
        this.xyGraph.setShowLegend(this.showLegend.getSelection());
        this.xyGraph.getPlotArea().setShowBorder(this.showPlotAreaBorder.getSelection());
        this.xyGraph.setTransparent(this.transparent.getSelection());
    }

    @Deprecated
    public XYGraph getXYGraph() {
        return (XYGraph)this.xyGraph;
    }

    public IXYGraph getIXYGraph() {
        return this.xyGraph;
    }
}

