/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.modifier.FilterModifier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FilterHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(FilterHandler.class);
    private static IChromatogramSelectionMSD chromatogramSelection;
    @Inject
    IEventBroker eventBroker;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        String perspectiveId = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.perspective";
        String viewId = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.part.interactiveDenoisingFilterMassSpectrumView";
        PerspectiveSwitchHandler.focusPerspectiveAndView((String)perspectiveId, (String)viewId);
        if (chromatogramSelection != null) {
            Display display = Display.getCurrent();
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start Denoising Filter");
            FilterModifier runnable = new FilterModifier(chromatogramSelection, this.eventBroker);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Denoising Filter finished");
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

