/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.ui.internal.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.settings.SumareaIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.ChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.IChromatogramIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IChromatogramIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.notifier.IntegrationResultUpdateNotifier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramIntegratorRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramIntegratorRunnable.class);
    private static final String CHROMATOGRAM_INTEGRATOR_ID = "org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.chromatogramIntegrator";
    private IChromatogramSelection chromatogramSelection;

    public ChromatogramIntegratorRunnable(IChromatogramSelection chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Sumarea Integrator", -1);
            SumareaIntegrationSettings chromatogramIntegrationSettings = new SumareaIntegrationSettings();
            IMarkedIons selectedIons = chromatogramIntegrationSettings.getSelectedIons();
            Set ions = PreferenceSupplier.getIons((String)"selectedIons", (String)"");
            PreferenceSupplier.setMarkedIons((IMarkedIons)selectedIons, (Set)ions);
            IChromatogramIntegratorProcessingInfo processingInfo = ChromatogramIntegrator.integrate((IChromatogramSelection)this.chromatogramSelection, (IChromatogramIntegrationSettings)chromatogramIntegrationSettings, (String)CHROMATOGRAM_INTEGRATOR_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((IProcessingInfo)processingInfo, (boolean)false);
            try {
                IChromatogramIntegrationResults chromatogramIntegrationResults = processingInfo.getChromatogramIntegrationResults();
                IntegrationResultUpdateNotifier.fireUpdateChange((IChromatogramIntegrationResults)chromatogramIntegrationResults);
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

