/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.converter;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramImportConverter;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.chromatogram.AbstractChromatogramWSDImportConverter;
import org.eclipse.chemclipse.wsd.converter.processing.chromatogram.ChromatogramWSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.processing.chromatogram.IChromatogramWSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.ChromatogramReaderWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.SpecificationValidator;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramImportConverter
extends AbstractChromatogramWSDImportConverter
implements IChromatogramImportConverter {
    private static final Logger logger = Logger.getLogger(ChromatogramImportConverter.class);

    public IChromatogramWSDImportConverterProcessingInfo convert(File file, IProgressMonitor monitor) {
        ChromatogramWSDImportConverterProcessingInfo processingInfo = new ChromatogramWSDImportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReaderWSD reader = new ChromatogramReaderWSD();
            monitor.subTask("Import Chromatogram");
            try {
                IChromatogramWSD chromatogram = reader.read(file, monitor);
                processingInfo.setChromatogram(chromatogram);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("Import Converter", "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IChromatogramOverviewImportConverterProcessingInfo convertOverview(File file, IProgressMonitor monitor) {
        ChromatogramOverviewImportConverterProcessingInfo processingInfo = new ChromatogramOverviewImportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReaderWSD reader = new ChromatogramReaderWSD();
            monitor.subTask("Import Chromatogram Overview");
            try {
                IChromatogramOverview chromatogramOverview = reader.readOverview(file, monitor);
                processingInfo.setChromatogramOverview(chromatogramOverview);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("Import Converter", "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

