/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.swt.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.graphics.Image;

public class PeakListLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IPeakCSD) {
            IPeakCSD peak = (IPeakCSD)element;
            IPeakModelCSD peakModel = peak.getPeakModel();
            switch (columnIndex) {
                case 0: {
                    text = decimalFormat.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0);
                    break;
                }
                case 1: {
                    if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                        text = Integer.toString((int)peakModel.getPeakMaximum().getRetentionIndex());
                        break;
                    }
                    text = decimalFormat.format(peakModel.getPeakMaximum().getRetentionIndex());
                    break;
                }
                case 2: {
                    if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                        text = Integer.toString((int)peak.getIntegratedArea());
                        break;
                    }
                    text = decimalFormat.format(peak.getIntegratedArea());
                    break;
                }
                case 3: {
                    text = decimalFormat.format((double)peakModel.getStartRetentionTime() / 60000.0);
                    break;
                }
                case 4: {
                    text = decimalFormat.format((double)peakModel.getStopRetentionTime() / 60000.0);
                    break;
                }
                case 5: {
                    text = decimalFormat.format((double)peakModel.getWidthByInflectionPoints() / 60000.0);
                    break;
                }
                case 6: 
                case 7: {
                    if (!(element instanceof IChromatogramPeakCSD)) break;
                    IChromatogramPeakCSD chromatogramPeak = (IChromatogramPeakCSD)element;
                    switch (columnIndex) {
                        case 6: {
                            text = Integer.toString(chromatogramPeak.getScanMax());
                            break;
                        }
                        case 7: {
                            text = decimalFormat.format(chromatogramPeak.getSignalToNoiseRatio());
                        }
                    }
                    break;
                }
                case 8: {
                    text = decimalFormat.format(peakModel.getLeading());
                    break;
                }
                case 9: {
                    text = decimalFormat.format(peakModel.getTailing());
                    break;
                }
                case 10: {
                    text = peak.getModelDescription();
                    break;
                }
                case 11: {
                    text = Integer.toString(peak.getSuggestedNumberOfComponents());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("peak.gif", "16x16");
    }
}

