/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figureparts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScaleTickLabels;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScaleTickMarks;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class RoundScale
extends AbstractScale {
    public static final int SPACE_BTW_MARK_LABEL = 1;
    private RoundScaleTickLabels tickLabels = new RoundScaleTickLabels(this);
    private RoundScaleTickMarks tickMarks = new RoundScaleTickMarks(this);
    private int lengthInPixels;
    private double lengthInDegrees;
    private int estimatedDonutWidth;
    private double startAngle = 225.0;
    private double endAngle = 315.0;
    private int radius;

    public RoundScale() {
        this.setMajorTickMarkStepHint(50);
        this.add((IFigure)this.tickMarks);
        this.add((IFigure)this.tickLabels);
    }

    private void calcEstimatedDonutWidth() {
        this.estimatedDonutWidth = Math.max(FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getLower())), (Font)this.getFont()).width, FigureUtilities.getTextExtents((String)this.format((Object)Double.valueOf((double)this.getRange().getUpper())), (Font)this.getFont()).width) + 1 + 8;
    }

    public int getLengthInPixels() {
        return this.lengthInPixels;
    }

    public double getLengthInDegrees() {
        return this.lengthInDegrees;
    }

    public double convertPixelToRadians(int pixels) {
        return this.lengthInDegrees * (Math.PI / 180) * (double)pixels / (double)this.lengthInPixels;
    }

    public int getEstimatedDonutWidth() {
        if (this.isDirty()) {
            this.calcEstimatedDonutWidth();
        }
        return this.estimatedDonutWidth;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        hHint = wHint = Math.min(wHint, hHint);
        Dimension size = new Dimension(wHint, hHint);
        return size;
    }

    public RoundScaleTickLabels getScaleTickLabels() {
        return this.tickLabels;
    }

    public RoundScaleTickMarks getScaleTickMarks() {
        return this.tickMarks;
    }

    public double getCoercedValuePosition(double value, boolean relative) {
        double min = this.getRange().getLower();
        double max = this.getRange().getUpper();
        value = max >= min ? (value < min ? min : (value > max ? max : value)) : (value > min ? min : (value < max ? max : value));
        return this.getValuePosition(value, relative);
    }

    public double getValuePosition(double value, boolean relative) {
        double valuePosition;
        this.updateTick();
        if (this.isLogScaleEnabled()) {
            if (value <= 0.0) {
                throw new IllegalArgumentException("Invalid value: value must be greater than 0");
            }
            valuePosition = this.startAngle - (Math.log10(value) - Math.log10(this.min)) / (Math.log10(this.max) - Math.log10(this.min)) * this.lengthInDegrees;
        } else {
            valuePosition = this.startAngle - (value - this.min) / (this.max - this.min) * this.lengthInDegrees;
        }
        if (relative) {
            valuePosition -= this.endAngle;
        }
        if (valuePosition < 0.0) {
            valuePosition += 360.0;
        }
        return valuePosition;
    }

    protected void layout() {
        super.layout();
        this.updateTick();
        Rectangle area = this.getClientArea();
        this.tickLabels.setBounds(area);
        this.tickMarks.setBounds(area);
    }

    public void setBounds(Rectangle rect) {
        if (!this.bounds.equals((Object)rect)) {
            this.setDirty(true);
        }
        rect.height = rect.width = Math.min(rect.width, rect.height);
        super.setBounds(rect);
    }

    public void setFont(Font font) {
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.tickLabels.setFont(font);
        super.setFont(font);
    }

    public void setForegroundColor(Color color) {
        this.tickMarks.setForegroundColor(color);
        this.tickLabels.setForegroundColor(color);
    }

    public void updateTick() {
        if (this.isDirty()) {
            if (this.getTickLabelSide() == AbstractScale.LabelSide.Primary) {
                this.radius = this.bounds.width / 2 - this.getEstimatedDonutWidth();
                if (this.endAngle - this.startAngle > 0.0) {
                    this.lengthInDegrees = 360.0 - (this.endAngle - this.startAngle);
                    this.lengthInPixels = (int)(Math.PI * 2 * (double)this.radius * (1.0 - (this.endAngle - this.startAngle) / 360.0));
                } else {
                    this.lengthInDegrees = this.startAngle - this.endAngle;
                    this.lengthInPixels = (int)(Math.PI * 2 * (double)this.radius * ((this.startAngle - this.endAngle) / 360.0));
                }
                this.tickLabels.update(this.lengthInDegrees, this.lengthInPixels);
                this.radius -= this.tickLabels.getTickLabelMaxOutLength();
            } else {
                this.radius = this.bounds.width / 2 - 1;
            }
            if (this.endAngle - this.startAngle > 0.0) {
                this.lengthInDegrees = 360.0 - (this.endAngle - this.startAngle);
                this.lengthInPixels = (int)(Math.PI * 2 * (double)this.radius * (1.0 - (this.endAngle - this.startAngle) / 360.0));
            } else {
                this.lengthInDegrees = this.startAngle - this.endAngle;
                this.lengthInPixels = (int)(Math.PI * 2 * (double)this.radius * ((this.startAngle - this.endAngle) / 360.0));
            }
            this.tickLabels.update(this.lengthInDegrees, this.lengthInPixels);
            this.setDirty(false);
        }
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void setStartAngle(double startAngle) {
        this.startAngle = startAngle;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setEndAngle(double endAngle) {
        this.endAngle = endAngle;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getInnerRadius() {
        this.updateTick();
        return this.radius;
    }
}

