/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.linsol.ReducedRowEchelonForm;

public class RrefGaussJordanRowPivot
implements ReducedRowEchelonForm<DenseMatrix64F> {
    double tol;

    @Override
    public void setTolerance(double tol) {
        this.tol = tol;
    }

    @Override
    public void reduce(DenseMatrix64F A, int coefficientColumns) {
        if (A.numCols < coefficientColumns) {
            throw new IllegalArgumentException("The system must be at least as wide as A");
        }
        int leadIndex = 0;
        int i = 0;
        while (i < coefficientColumns) {
            int pivotRow = -1;
            double maxValue = this.tol;
            int row = leadIndex;
            while (row < A.numRows) {
                double v = Math.abs(A.data[row * A.numCols + i]);
                if (v > maxValue) {
                    maxValue = v;
                    pivotRow = row;
                }
                ++row;
            }
            if (pivotRow != -1) {
                if (leadIndex != pivotRow) {
                    RrefGaussJordanRowPivot.swapRows(A, leadIndex, pivotRow);
                }
                row = 0;
                while (row < A.numRows) {
                    if (row != leadIndex) {
                        int indexPivot = leadIndex * A.numCols + i;
                        int indexTarget = row * A.numCols + i;
                        double alpha = A.data[indexTarget] / A.data[indexPivot++];
                        A.data[indexTarget++] = 0.0;
                        int col = i + 1;
                        while (col < A.numCols) {
                            int n = indexTarget++;
                            A.data[n] = A.data[n] - A.data[indexPivot++] * alpha;
                            ++col;
                        }
                    }
                    ++row;
                }
                int indexPivot = leadIndex * A.numCols + i;
                double alpha = 1.0 / A.data[indexPivot];
                A.data[indexPivot++] = 1.0;
                int col = i + 1;
                while (col < A.numCols) {
                    int n = indexPivot++;
                    A.data[n] = A.data[n] * alpha;
                    ++col;
                }
                ++leadIndex;
            }
            ++i;
        }
    }

    protected static void swapRows(DenseMatrix64F A, int rowA, int rowB) {
        int indexA = rowA * A.numCols;
        int indexB = rowB * A.numCols;
        int i = 0;
        while (i < A.numCols) {
            double temp = A.data[indexA];
            A.data[indexA] = A.data[indexB];
            A.data[indexB] = temp;
            ++i;
            ++indexA;
            ++indexB;
        }
    }
}

