/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CCommonOps;
import org.ejml.ops.CSpecializedOps;

public class LinearSolverQr_CD64
extends LinearSolverAbstract_CD64 {
    private QRDecomposition<CDenseMatrix64F> decomposer;
    protected int maxRows = -1;
    protected int maxCols = -1;
    protected CDenseMatrix64F Q;
    protected CDenseMatrix64F Qt;
    protected CDenseMatrix64F R;
    private CDenseMatrix64F Y;
    private CDenseMatrix64F Z;

    public LinearSolverQr_CD64(QRDecomposition<CDenseMatrix64F> decomposer) {
        this.decomposer = decomposer;
    }

    public void setMaxSize(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.Q = new CDenseMatrix64F(maxRows, maxRows);
        this.Qt = new CDenseMatrix64F(maxRows, maxRows);
        this.R = new CDenseMatrix64F(maxRows, maxCols);
        this.Y = new CDenseMatrix64F(maxRows, 1);
        this.Z = new CDenseMatrix64F(maxRows, 1);
    }

    @Override
    public boolean setA(CDenseMatrix64F A) {
        if (A.numRows > this.maxRows || A.numCols > this.maxCols) {
            this.setMaxSize(A.numRows, A.numCols);
        }
        this._setA(A);
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.Q.reshape(this.numRows, this.numRows);
        this.R.reshape(this.numRows, this.numCols);
        this.decomposer.getQ(this.Q, false);
        this.decomposer.getR(this.R, false);
        CCommonOps.transposeConjugate(this.Q, this.Qt);
        return true;
    }

    @Override
    public double quality() {
        return CSpecializedOps.qualityTriangular(this.R);
    }

    @Override
    public void solve(CDenseMatrix64F B, CDenseMatrix64F X) {
        if (X.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (B.numRows != this.numRows || B.numCols != X.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int BnumCols = B.numCols;
        this.Y.reshape(this.numRows, 1);
        this.Z.reshape(this.numRows, 1);
        int colB = 0;
        while (colB < BnumCols) {
            int i = 0;
            while (i < this.numRows) {
                int indexB = B.getIndex(i, colB);
                this.Y.data[i * 2] = B.data[indexB];
                this.Y.data[i * 2 + 1] = B.data[indexB + 1];
                ++i;
            }
            CCommonOps.mult(this.Qt, this.Y, this.Z);
            CTriangularSolver.solveU(this.R.data, this.Z.data, this.numCols);
            i = 0;
            while (i < this.numCols) {
                X.set(i, colB, this.Z.data[i * 2], this.Z.data[i * 2 + 1]);
                ++i;
            }
            ++colB;
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecomposition<CDenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }

    public QRDecomposition<CDenseMatrix64F> getDecomposer() {
        return this.decomposer;
    }

    public CDenseMatrix64F getQ() {
        return this.Q;
    }

    public CDenseMatrix64F getR() {
        return this.R;
    }
}

