/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.data.DenseMatrix64F;

public class LUDecompositionAlt_D64
extends LUDecompositionBase_D64 {
    @Override
    public boolean decompose(DenseMatrix64F a) {
        this.decomposeCommonInit(a);
        double[] LUcolj = this.vv;
        int j = 0;
        while (j < this.n) {
            double lujj;
            int i = 0;
            while (i < this.m) {
                LUcolj[i] = this.dataLU[i * this.n + j];
                ++i;
            }
            i = 0;
            while (i < this.m) {
                int rowIndex = i * this.n;
                int kmax = i < j ? i : j;
                double s = 0.0;
                int k = 0;
                while (k < kmax) {
                    s += this.dataLU[rowIndex + k] * LUcolj[k];
                    ++k;
                }
                int n = i++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                this.dataLU[rowIndex + j] = d;
            }
            int p = j;
            double max = Math.abs(LUcolj[p]);
            int i2 = j + 1;
            while (i2 < this.m) {
                double v = Math.abs(LUcolj[i2]);
                if (v > max) {
                    p = i2;
                    max = v;
                }
                ++i2;
            }
            if (p != j) {
                int rowP = p * this.n;
                int rowJ = j * this.n;
                int endP = rowP + this.n;
                while (rowP < endP) {
                    double t = this.dataLU[rowP];
                    this.dataLU[rowP] = this.dataLU[rowJ];
                    this.dataLU[rowJ] = t;
                    ++rowP;
                    ++rowJ;
                }
                int k = this.pivot[p];
                this.pivot[p] = this.pivot[j];
                this.pivot[j] = k;
                this.pivsign = -this.pivsign;
            }
            this.indx[j] = p;
            if (j < this.m && (lujj = this.dataLU[j * this.n + j]) != 0.0) {
                int i3 = j + 1;
                while (i3 < this.m) {
                    int n = i3 * this.n + j;
                    this.dataLU[n] = this.dataLU[n] / lujj;
                    ++i3;
                }
            }
            ++j;
        }
        return true;
    }
}

