/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;

public class QrHelperFunctions_CD64 {
    public static double findMax(double[] u, int startU, int length) {
        double max = -1.0;
        int index = startU * 2;
        int stopIndex = (startU + length) * 2;
        while (index < stopIndex) {
            double real = u[index++];
            int n = index++;
            double img = u[n];
            double val = real * real + img * img;
            if (!(val > max)) continue;
            max = val;
        }
        return Math.sqrt(max);
    }

    public static void divideElements(int j, int numRows, double[] u, int startU, double realA, double imagA) {
        double mag2 = realA * realA + imagA * imagA;
        int index = (j + startU) * 2;
        int i = j;
        while (i < numRows) {
            double realU = u[index];
            double imagU = u[index + 1];
            u[index++] = (realU * realA + imagU * imagA) / mag2;
            u[index++] = (imagU * realA - realU * imagA) / mag2;
            ++i;
        }
    }

    public static double computeTauGammaAndDivide(int start, int stop, double[] x, double max, Complex64F tau) {
        double bottom;
        double top;
        int index = start * 2;
        double nx = 0.0;
        int i = start;
        while (i < stop) {
            int n = index++;
            double d = x[n] / max;
            x[n] = d;
            double realX = d;
            int n2 = index++;
            double d2 = x[n2] / max;
            x[n2] = d2;
            double imagX = d2;
            nx += realX * realX + imagX * imagX;
            ++i;
        }
        nx = Math.sqrt(nx);
        double real_x0 = x[2 * start];
        double imag_x0 = x[2 * start + 1];
        double mag_x0 = Math.sqrt(real_x0 * real_x0 + imag_x0 * imag_x0);
        if (mag_x0 == 0.0) {
            tau.real = nx;
            tau.imaginary = 0.0;
        } else {
            tau.real = real_x0 / mag_x0 * nx;
            tau.imaginary = imag_x0 / mag_x0 * nx;
        }
        if (real_x0 * tau.real < 0.0) {
            tau.real = -tau.real;
            tau.imaginary = -tau.imaginary;
            top = nx * nx - nx * mag_x0;
            bottom = mag_x0 * mag_x0 - 2.0 * nx * mag_x0 + nx * nx;
        } else {
            top = nx * nx + nx * mag_x0;
            bottom = mag_x0 * mag_x0 + 2.0 * nx * mag_x0 + nx * nx;
        }
        return bottom / top;
    }

    public static void rank1UpdateMultR(CDenseMatrix64F A, double[] u, int offsetU, double gammaR, int colA0, int w0, int w1, double[] _temp) {
        int indexU = (w0 + offsetU) * 2;
        double realU = u[indexU];
        double imagU = -u[indexU + 1];
        int indexA = w0 * A.numCols * 2 + colA0 * 2;
        int indexTmp = colA0 * 2;
        int i = colA0;
        while (i < A.numCols) {
            double realA = A.data[indexA++];
            double imagA = A.data[indexA++];
            _temp[indexTmp++] = realU * realA - imagU * imagA;
            _temp[indexTmp++] = realU * imagA + imagU * realA;
            ++i;
        }
        int k = w0 + 1;
        while (k < w1) {
            indexA = k * A.numCols * 2 + colA0 * 2;
            indexU = (k + offsetU) * 2;
            indexTmp = colA0 * 2;
            realU = u[indexU];
            imagU = -u[indexU + 1];
            int i2 = colA0;
            while (i2 < A.numCols) {
                double realA = A.data[indexA++];
                double imagA = A.data[indexA++];
                int n = indexTmp++;
                _temp[n] = _temp[n] + (realU * realA - imagU * imagA);
                int n2 = indexTmp++;
                _temp[n2] = _temp[n2] + (realU * imagA + imagU * realA);
                ++i2;
            }
            ++k;
        }
        indexTmp = colA0 * 2;
        i = colA0;
        while (i < A.numCols) {
            double realTmp = _temp[indexTmp];
            double imagTmp = _temp[indexTmp + 1];
            _temp[indexTmp++] = gammaR * realTmp;
            _temp[indexTmp++] = gammaR * imagTmp;
            ++i;
        }
        i = w0;
        while (i < w1) {
            indexA = i * A.numCols * 2 + colA0 * 2;
            indexU = (i + offsetU) * 2;
            indexTmp = colA0 * 2;
            realU = u[indexU];
            imagU = u[indexU + 1];
            int j = colA0;
            while (j < A.numCols) {
                double realTmp = _temp[indexTmp++];
                double imagTmp = _temp[indexTmp++];
                int n = indexA++;
                A.data[n] = A.data[n] - (realU * realTmp - imagU * imagTmp);
                int n3 = indexA++;
                A.data[n3] = A.data[n3] - (realU * imagTmp + imagU * realTmp);
                ++j;
            }
            ++i;
        }
    }

    public static void rank1UpdateMultL(CDenseMatrix64F A, double[] u, double gammaR, double gammaI, int colA0, int w0, int w1) {
        int i = colA0;
        while (i < A.numRows) {
            double realU;
            int startIndex = i * A.numCols * 2 + w0 * 2;
            double realSum = 0.0;
            double imagSum = 0.0;
            int rowIndex = startIndex;
            int indexU = w0 * 2;
            int j = w0;
            while (j < w1) {
                double realA = A.data[rowIndex++];
                double imajA = A.data[rowIndex++];
                realU = u[indexU++];
                double imajU = u[indexU++];
                realSum += realA * realU - imajA * imajU;
                imagSum += realA * imajU + imajA * realU;
                ++j;
            }
            double realTmp = -(gammaR * realSum - gammaI * imagSum);
            double imagTmp = -(gammaR * imagSum + gammaI * realSum);
            rowIndex = startIndex;
            indexU = w0 * 2;
            int j2 = w0;
            while (j2 < w1) {
                realU = u[indexU++];
                double imagU = -u[indexU++];
                int n = rowIndex++;
                A.data[n] = A.data[n] + (realTmp * realU - imagTmp * imagU);
                int n2 = rowIndex++;
                A.data[n2] = A.data[n2] + (realTmp * imagU + imagTmp * realU);
                ++j2;
            }
            ++i;
        }
    }
}

