/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditorRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.IRowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class EditUtils {
    public static ILayerCell getLastSelectedCell(SelectionLayer selectionLayer) {
        PositionCoordinate selectionAnchor = selectionLayer.getSelectionAnchor();
        return selectionLayer.getCellByPosition(selectionAnchor.columnPosition, selectionAnchor.rowPosition);
    }

    public static ICellEditor getLastSelectedCellEditor(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        ILayerCell lastSelectedCell = EditUtils.getLastSelectedCell(selectionLayer);
        if (lastSelectedCell != null) {
            List<String> lastSelectedCellLabelsArray = lastSelectedCell.getConfigLabels().getLabels();
            return configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", lastSelectedCellLabelsArray);
        }
        return null;
    }

    public static boolean activateLastSelectedCellEditor(SelectionLayer selectionLayer, IConfigRegistry configRegistry, boolean byTraversal) {
        List<String> lastSelectedCellLabelsArray;
        ICellEditor editor;
        ILayerCell lastSelectedCell = EditUtils.getLastSelectedCell(selectionLayer);
        if (lastSelectedCell != null && (editor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", lastSelectedCellLabelsArray = lastSelectedCell.getConfigLabels().getLabels())) != null) {
            return !byTraversal || editor.activateOnTraversal(configRegistry, lastSelectedCellLabelsArray);
        }
        return false;
    }

    public static boolean allCellsEditable(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        return EditUtils.allCellsEditable(EditUtils.getSelectedCellsForEditing(selectionLayer), configRegistry);
    }

    public static boolean allCellsEditable(Collection<ILayerCell> selectedCells, IConfigRegistry configRegistry) {
        if (selectedCells != null) {
            for (ILayerCell layerCell : selectedCells) {
                LabelStack labelStack = layerCell.getConfigLabels();
                IEditableRule editableRule = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", labelStack.getLabels());
                if (editableRule != null && editableRule.isEditable(layerCell, configRegistry)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isCellEditable(ILayer layer, IConfigRegistry configRegistry, PositionCoordinate cellCoords) {
        ILayerCell layerCell = layer.getCellByPosition(cellCoords.columnPosition, cellCoords.rowPosition);
        LabelStack labelStack = layerCell.getConfigLabels();
        IEditableRule editableRule = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", labelStack.getLabels());
        if (editableRule == null) {
            return false;
        }
        return editableRule.isEditable(layerCell, configRegistry);
    }

    public static boolean isEditorSame(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        return EditUtils.isEditorSame(EditUtils.getSelectedCellsForEditing(selectionLayer), configRegistry);
    }

    public static boolean isEditorSame(Collection<ILayerCell> selectedCells, IConfigRegistry configRegistry) {
        if (selectedCells != null) {
            ICellEditor lastSelectedCellEditor = null;
            for (ILayerCell selectedCell : selectedCells) {
                LabelStack labelStack = selectedCell.getConfigLabels();
                ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", labelStack.getLabels());
                if (lastSelectedCellEditor == null) {
                    lastSelectedCellEditor = cellEditor;
                }
                if (cellEditor == lastSelectedCellEditor) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isConverterSame(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        return EditUtils.isConverterSame(EditUtils.getSelectedCellsForEditing(selectionLayer), configRegistry);
    }

    public static boolean isConverterSame(Collection<ILayerCell> selectedCells, IConfigRegistry configRegistry) {
        if (selectedCells != null) {
            HashSet converterSet = new HashSet();
            for (ILayerCell selectedCell : selectedCells) {
                LabelStack labelStack = selectedCell.getConfigLabels();
                IDisplayConverter dataTypeConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "EDIT", labelStack.getLabels());
                if (dataTypeConverter != null) {
                    converterSet.add(dataTypeConverter.getClass());
                }
                if (converterSet.size() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValueSame(SelectionLayer selectionLayer) {
        return EditUtils.isValueSame(EditUtils.getSelectedCellsForEditing(selectionLayer));
    }

    public static boolean isValueSame(Collection<ILayerCell> selectedCells) {
        if (selectedCells != null) {
            Object lastSelectedValue = null;
            for (ILayerCell layerCell : selectedCells) {
                Object cellValue = layerCell.getDataValue();
                if (lastSelectedValue == null) {
                    lastSelectedValue = cellValue;
                }
                if ((cellValue == null || cellValue.equals(lastSelectedValue)) && (cellValue != null || lastSelectedValue == null)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<ILayerCell> getSelectedCellsForEditing(SelectionLayer selectionLayer) {
        Collection<ILayerCell> selectedCells = null;
        if (selectionLayer.getSelectionModel() instanceof IRowSelectionModel) {
            selectedCells = new ArrayList<ILayerCell>();
            if (selectionLayer.getSelectionModel().getSelectedRowCount() == 1) {
                selectedCells.add(EditUtils.getLastSelectedCell(selectionLayer));
            } else {
                ILayerCell anchor = EditUtils.getLastSelectedCell(selectionLayer);
                for (ILayerCell cell : selectionLayer.getSelectedCells()) {
                    if (cell.getColumnPosition() != anchor.getColumnPosition()) continue;
                    selectedCells.add(cell);
                }
            }
        } else {
            selectedCells = selectionLayer.getSelectedCells();
        }
        return selectedCells;
    }

    @Deprecated
    public static boolean commitAndCloseActiveEditor() {
        ICellEditor activeCellEditor = ActiveCellEditorRegistry.getActiveCellEditor();
        if (activeCellEditor != null) {
            return activeCellEditor.commit(SelectionLayer.MoveDirectionEnum.NONE, true);
        }
        return true;
    }
}

