/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.connector.supplier.microsoft.office.ui.wizards;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.rcp.connector.supplier.microsoft.office.ui.Activator;
import org.eclipse.chemclipse.rcp.connector.supplier.microsoft.office.ui.wizards.OfficeFileWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class OfficeFileWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = Logger.getLogger(OfficeFileWizard.class);
    private OfficeFileWizardPage page;

    public OfficeFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPage(IWizardPage page) {
        super.addPage(page);
        if (page instanceof OfficeFileWizardPage) {
            this.page = (OfficeFileWizardPage)page;
        }
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        OfficeFileWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, runnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        IContainer container;
        IFile file;
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        if (!(file = (container = (IContainer)resource).getFile((IPath)new Path(fileName))).exists()) {
            try {
                FileOutputStream outputStream = new FileOutputStream(file.getLocation().toOSString());
                String extension = file.getFileExtension();
                if (extension.equals("xls")) {
                    HSSFWorkbook hssfWorkbook = new HSSFWorkbook();
                    hssfWorkbook.createSheet("ChemClipse Worksheet");
                    hssfWorkbook.write((OutputStream)outputStream);
                    outputStream.flush();
                    outputStream.close();
                } else if (extension.equals("xlsx")) {
                    XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
                    xssfWorkbook.createSheet("ChemClipse Worksheet");
                    xssfWorkbook.write((OutputStream)outputStream);
                    outputStream.flush();
                    outputStream.close();
                } else if (extension.equals("doc")) {
                    XWPFDocument xwpfDocument = new XWPFDocument();
                    xwpfDocument.write((OutputStream)outputStream);
                    outputStream.flush();
                    outputStream.close();
                } else if (extension.equals("docx")) {
                    XWPFDocument xwpfDocument = new XWPFDocument();
                    xwpfDocument.write((OutputStream)outputStream);
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.warn((Object)e);
            }
        }
        container.refreshLocal(1, monitor);
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, message, null);
        throw new CoreException((IStatus)status);
    }
}

