/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.core;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.core.IBackgroundIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.ISegment;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.Segment;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.SegmentAreaCalculator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;

public class BackgroundIntegrator
implements IBackgroundIntegrator {
    private static final Logger logger = Logger.getLogger(BackgroundIntegrator.class);

    @Override
    public double integrate(IChromatogramSelection chromatogramSelection) {
        double backgroundArea = 0.0;
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        try {
            TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor(chromatogram);
            ITotalScanSignals totalIonSignals = totalIonSignalExtractor.getTotalScanSignals();
            double segmentArea = 0.0;
            int scan = startScan;
            while (scan < stopScan) {
                ITotalScanSignal startSignal = totalIonSignals.getTotalScanSignal(scan);
                ITotalScanSignal stopSignal = totalIonSignals.getTotalScanSignal(scan + 1);
                if (startSignal != null && stopSignal != null) {
                    int start = startSignal.getRetentionTime();
                    int stop = stopSignal.getRetentionTime();
                    segmentArea = this.calculateArea(start, stop, baselineModel.getBackgroundAbundance(start), baselineModel.getBackgroundAbundance(stop));
                    backgroundArea += segmentArea;
                }
                ++scan;
            }
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        return backgroundArea;
    }

    private double calculateArea(int startRetentionTime, int stopRetentionTime, float startAbundance, float stopAbundance) {
        double integratedArea = 0.0;
        Point psp1 = new Point((double)startRetentionTime, (double)startAbundance);
        Point psp2 = new Point((double)stopRetentionTime, (double)stopAbundance);
        Point pbp1 = new Point((double)startRetentionTime, 0.0);
        Point pbp2 = new Point((double)stopRetentionTime, 0.0);
        Segment segment = new Segment((IPoint)pbp1, (IPoint)pbp2, (IPoint)psp1, (IPoint)psp2);
        integratedArea = SegmentAreaCalculator.calculateSegmentArea((ISegment)segment) / 100.0;
        return integratedArea;
    }
}

