/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.incos.comparator;

import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.AbstractMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.math.GeometricDistanceCalculator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.IMassSpectrumComparatorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.comparison.processing.MassSpectrumComparatorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.incos.results.MassSpectrumComparisonResult;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumComparisonResult;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;

public class MassSpectrumComparator
extends AbstractMassSpectrumComparator
implements IMassSpectrumComparator {
    public static final String COMPARATOR_ID = "org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.incos";
    private static final Logger logger = Logger.getLogger(MassSpectrumComparator.class);
    private static final int NORMALIZATION_FACTOR = 100;

    public IMassSpectrumComparatorProcessingInfo compare(IScanMSD unknown, IScanMSD reference) {
        MassSpectrumComparatorProcessingInfo processingInfo = new MassSpectrumComparatorProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(unknown, reference);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            GeometricDistanceCalculator geometricDistanceCalculator = new GeometricDistanceCalculator();
            IScanMSD unknownAdjusted = this.adjustMassSpectrum(unknown);
            IScanMSD referenceAdjusted = this.adjustMassSpectrum(reference);
            IExtractedIonSignal signalU = unknownAdjusted.getExtractedIonSignal();
            IExtractedIonSignal signalR = referenceAdjusted.getExtractedIonSignal();
            float matchFactor = geometricDistanceCalculator.calculate(unknownAdjusted, referenceAdjusted, signalU.getIonRange()) * 100.0f;
            float reverseMatchFactor = geometricDistanceCalculator.calculate(referenceAdjusted, unknownAdjusted, signalR.getIonRange()) * 100.0f;
            float matchFactorDirect = geometricDistanceCalculator.calculate(unknownAdjusted, referenceAdjusted) * 100.0f;
            float reverseMatchFactorDirect = geometricDistanceCalculator.calculate(referenceAdjusted, unknownAdjusted) * 100.0f;
            MassSpectrumComparisonResult massSpectrumComparisonResult = new MassSpectrumComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect);
            processingInfo.setMassSpectrumComparisonResult((IMassSpectrumComparisonResult)massSpectrumComparisonResult);
        }
        return processingInfo;
    }

    private IScanMSD adjustMassSpectrum(IScanMSD massSpectrum) {
        ScanMSD adjustedMassSpectrum = new ScanMSD();
        try {
            IScanMSD massSpectrumNormalized = massSpectrum.makeDeepCopy();
            massSpectrumNormalized.normalize(100.0f);
            IExtractedIonSignal signal = massSpectrumNormalized.getExtractedIonSignal();
            int startIon = signal.getStartIon();
            int stopIon = signal.getStopIon();
            int ion = startIon;
            while (ion <= stopIon) {
                float abundance = signal.getAbundance(ion);
                if (abundance > 0.0f) {
                    try {
                        Ion adjustedIon = new Ion((double)ion, (float)Math.sqrt(abundance * (float)ion));
                        adjustedMassSpectrum.addIon((IIon)adjustedIon);
                    }
                    catch (AbundanceLimitExceededException e) {
                        logger.warn((Object)e);
                    }
                    catch (IonLimitExceededException e) {
                        logger.warn((Object)e);
                    }
                }
                ++ion;
            }
        }
        catch (CloneNotSupportedException e1) {
            logger.warn((Object)e1);
        }
        return adjustedMassSpectrum;
    }
}

