/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ICombinedIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.internal.results.IIntegrationResultsUpdater;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt.ChromatogramIntegrationResultsUI;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt.OverviewIntegrationResultsUI;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.swt.PeakIntegrationResultsUI;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class IntegrationResultsTabFolderUI
extends Composite
implements IIntegrationResultsUpdater {
    private TabFolder tabFolder;
    private TabItem overviewIntegrationResultsTab;
    private TabItem chromatogramIntegrationResultsTab;
    private TabItem peakIntegrationResultsTab;
    private OverviewIntegrationResultsUI overviewResultsUI;
    private ChromatogramIntegrationResultsUI chromatogramResultsUI;
    private PeakIntegrationResultsUI peakResultUI;

    public IntegrationResultsTabFolderUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    @Override
    public void update(ICombinedIntegrationResult combinedIntegrationResult) {
        if (combinedIntegrationResult != null) {
            IChromatogramIntegrationResults chromatogramIntegrationResults = combinedIntegrationResult.getChromatogramIntegrationResults();
            IPeakIntegrationResults peakIntegrationResults = combinedIntegrationResult.getPeakIntegrationResults();
            double chromatogramArea = chromatogramIntegrationResults.getTotalChromatogramArea();
            double backgroundArea = chromatogramIntegrationResults.getTotalBackgroundArea();
            double peakArea = peakIntegrationResults.getTotalPeakArea();
            this.overviewResultsUI.update(chromatogramArea, backgroundArea, peakArea);
            this.peakResultUI.update(peakIntegrationResults);
            this.chromatogramResultsUI.update(chromatogramIntegrationResults);
        } else {
            this.overviewResultsUI.update(0.0, 0.0, 0.0);
            this.chromatogramResultsUI.update(null);
            this.peakResultUI.update(null);
        }
        this.tabFolder.setSelection(this.overviewIntegrationResultsTab);
    }

    @Override
    public void update(IChromatogramIntegrationResults chromatogramIntegrationResults) {
        double chromatogramArea = chromatogramIntegrationResults.getTotalChromatogramArea();
        double backgroundArea = chromatogramIntegrationResults.getTotalBackgroundArea();
        double peakArea = 0.0;
        this.overviewResultsUI.update(chromatogramArea, backgroundArea, peakArea);
        this.peakResultUI.update(null);
        this.chromatogramResultsUI.update(chromatogramIntegrationResults);
        this.tabFolder.setSelection(this.chromatogramIntegrationResultsTab);
    }

    @Override
    public void update(IPeakIntegrationResults peakIntegrationResults) {
        double chromatogramArea = 0.0;
        double backgroundArea = 0.0;
        double peakArea = peakIntegrationResults.getTotalPeakArea();
        this.overviewResultsUI.update(chromatogramArea, backgroundArea, peakArea);
        this.chromatogramResultsUI.update(null);
        this.peakResultUI.update(peakIntegrationResults);
        this.tabFolder.setSelection(this.peakIntegrationResultsTab);
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        composite.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder(composite, 2048);
        this.overviewIntegrationResultsTab = new TabItem(this.tabFolder, 0);
        this.overviewIntegrationResultsTab.setText("Overview");
        Composite overviewComposite = new Composite((Composite)this.tabFolder, 0);
        overviewComposite.setLayout((Layout)new FillLayout());
        this.overviewIntegrationResultsTab.setControl((Control)overviewComposite);
        this.overviewResultsUI = new OverviewIntegrationResultsUI(overviewComposite, 0);
        this.chromatogramIntegrationResultsTab = new TabItem(this.tabFolder, 0);
        this.chromatogramIntegrationResultsTab.setText("Chromatogram Results");
        Composite chromatogramComposite = new Composite((Composite)this.tabFolder, 0);
        chromatogramComposite.setLayout((Layout)new FillLayout());
        this.chromatogramIntegrationResultsTab.setControl((Control)chromatogramComposite);
        this.chromatogramResultsUI = new ChromatogramIntegrationResultsUI(chromatogramComposite, 0);
        this.peakIntegrationResultsTab = new TabItem(this.tabFolder, 0);
        this.peakIntegrationResultsTab.setText("Peak Results");
        Composite peakComposite = new Composite((Composite)this.tabFolder, 0);
        peakComposite.setLayout((Layout)new FillLayout());
        this.peakIntegrationResultsTab.setControl((Control)peakComposite);
        this.peakResultUI = new PeakIntegrationResultsUI(peakComposite, 0);
        this.tabFolder.pack();
    }
}

