/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.internal.provider;

import java.text.DecimalFormat;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PeakIntegrationResultsLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IPeakIntegrationResult) {
            IPeakIntegrationResult peakIntegrationResult = (IPeakIntegrationResult)element;
            switch (columnIndex) {
                case 0: {
                    text = decimalFormat.format((double)peakIntegrationResult.getStartRetentionTime() / 60000.0);
                    break;
                }
                case 1: {
                    text = decimalFormat.format((double)peakIntegrationResult.getStopRetentionTime() / 60000.0);
                    break;
                }
                case 2: {
                    text = decimalFormat.format(peakIntegrationResult.getIntegratedArea());
                    break;
                }
                case 3: {
                    text = this.getIntegratedIons(peakIntegrationResult);
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("peak.gif", "16x16");
    }

    private String getIntegratedIons(IPeakIntegrationResult peakIntegrationResult) {
        Set ions = peakIntegrationResult.getIntegratedIons();
        StringBuilder builder = new StringBuilder();
        ions.size();
        for (Integer ion : ions) {
            if ((double)ion.intValue() == 0.0) {
                builder.append("TIC");
            } else {
                builder.append(ion);
            }
            builder.append(" ");
        }
        return builder.toString();
    }
}

