/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class ErrorExpression
extends Expression {
    private XPathException exception;

    public ErrorExpression(XPathException exception) {
        this.exception = exception;
        exception.setLocator(this);
    }

    public XPathException getException() {
        return this.exception;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        XPathException err = new XPathException(this.exception.getMessage());
        err.setLocator(this);
        err.setErrorCode(this.exception.getErrorCodeLocalPart());
        err.setXPathContext(context);
        throw err;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        this.evaluateItem(context);
        return null;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    public int computeCardinality() {
        return 57344;
    }

    public Expression copy() {
        return new ErrorExpression(this.exception);
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("error");
        destination.emitAttribute("message", this.exception.getMessage());
        destination.endElement();
    }
}

