/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.BatchProcessJobEditor;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.wizards.BatchProcessWizardDialog;
import org.eclipse.chemclipse.converter.model.IChromatogramOutputEntry;
import org.eclipse.chemclipse.msd.converter.support.ConverterTypeSupportMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.wizards.ChromatogramOutputEntriesWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OutputEntriesPage
implements IMultiEditorPage {
    private FormToolkit toolkit;
    private int pageIndex;
    private IBatchProcessJob batchProcessJob;
    private Table outputFilesTable;

    public OutputEntriesPage(BatchProcessJobEditor editorPart, Composite container) {
        this.createPage(editorPart, container);
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void setBatchProcessJob(IBatchProcessJob batchProcessJob) {
        if (batchProcessJob != null) {
            this.batchProcessJob = batchProcessJob;
            this.reloadTable();
        }
    }

    private void createPage(BatchProcessJobEditor editorPart, Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(parent);
        Composite scrolledFormComposite = scrolledForm.getBody();
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Output File Editor");
        this.createOutputFilesSection(scrolledFormComposite, editorPart);
        this.pageIndex = editorPart.addPage((Control)parent);
    }

    private void createOutputFilesSection(Composite parent, BatchProcessJobEditor editorPart) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Output files");
        section.setDescription("Select the output file formats. Use the add and remove buttons.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        this.createTable(client);
        this.createButtons(client, editorPart);
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createTable(Composite client) {
        this.outputFilesTable = this.toolkit.createTable(client, 2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.widthHint = 100;
        gridData.verticalSpan = 2;
        this.outputFilesTable.setLayoutData((Object)gridData);
        this.outputFilesTable.setHeaderVisible(true);
        this.outputFilesTable.setLinesVisible(true);
    }

    private void createButtons(Composite client, BatchProcessJobEditor editorPart) {
        this.createAddButton(client, editorPart);
        this.createRemoveButton(client, editorPart);
    }

    private void createAddButton(Composite client, final BatchProcessJobEditor editorPart) {
        Button add = this.toolkit.createButton(client, "Add", 8);
        add.setLayoutData((Object)new GridData(258));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Shell shell = Display.getCurrent().getActiveShell();
                ChromatogramOutputEntriesWizard outputEntriesWizard = new ChromatogramOutputEntriesWizard();
                BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(shell, (IWizard)outputEntriesWizard);
                wizardDialog.create();
                int returnCode = wizardDialog.open();
                if (returnCode == 0) {
                    IChromatogramOutputEntry outputEntry = outputEntriesWizard.getChromatogramOutputEntry();
                    if (outputEntry != null) {
                        List outputEntries = OutputEntriesPage.this.batchProcessJob.getChromatogramOutputEntries();
                        outputEntries.add(outputEntry);
                        OutputEntriesPage.this.reloadTable();
                        editorPart.setDirty();
                    } else {
                        MessageBox messageBox = new MessageBox(shell);
                        messageBox.setText("Error Add Output Entry");
                        messageBox.setMessage("Please select a valid chromatogram output converter and folder.");
                        messageBox.open();
                    }
                }
            }
        });
    }

    private void createRemoveButton(Composite client, final BatchProcessJobEditor editorPart) {
        Button remove = this.toolkit.createButton(client, "Remove", 8);
        remove.setLayoutData((Object)new GridData(258));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                OutputEntriesPage.this.removeEntries(OutputEntriesPage.this.outputFilesTable.getSelectionIndices());
                editorPart.setDirty();
            }
        });
    }

    private void removeEntries(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        this.outputFilesTable.remove(indices);
        List outputEntries = this.batchProcessJob.getChromatogramOutputEntries();
        int counter = 0;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            outputEntries.remove(index -= counter);
            ++counter;
            ++n2;
        }
    }

    private void reloadTable() {
        if (this.batchProcessJob != null && this.outputFilesTable != null) {
            this.outputFilesTable.removeAll();
            String[] titles = new String[]{"Converter Name", "Output Folder", "Converter Id"};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.outputFilesTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            ConverterTypeSupportMSD converterTypeSupport = new ConverterTypeSupportMSD();
            List outputEntries = this.batchProcessJob.getChromatogramOutputEntries();
            for (IChromatogramOutputEntry entry : outputEntries) {
                TableItem item = new TableItem(this.outputFilesTable, 0);
                item.setText(0, converterTypeSupport.getConverterName(entry));
                item.setText(1, entry.getOutputFolder());
                item.setText(2, entry.getConverterId());
            }
            int i2 = 0;
            while (i2 < titles.length) {
                this.outputFilesTable.getColumn(i2).pack();
                ++i2;
            }
        }
    }
}

