/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.console.ApplicationLogConsole;
import org.eclipse.cft.server.ui.internal.console.CloudConsoleManager;
import org.eclipse.cft.server.ui.internal.console.CloudFoundryConsole;
import org.eclipse.cft.server.ui.internal.console.ConsoleConfig;
import org.eclipse.cft.server.ui.internal.console.StandardLogContentType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.wst.server.core.IServer;

public class ApplicationLogConsoleManager
extends CloudConsoleManager {
    private IConsoleManager consoleManager;
    Map<String, ApplicationLogConsole> consoleByUri;
    private final IConsoleListener listener = new IConsoleListener(){

        public void consolesAdded(IConsole[] consoles) {
        }

        public void consolesRemoved(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if ("org.eclipse.cft.server.appcloud".equals(console.getType())) {
                    Object server = ((MessageConsole)console).getAttribute("org.eclipse.cft.server.Server");
                    Object app = ((MessageConsole)console).getAttribute("org.eclipse.cft.server.CloudApp");
                    Object index = ((MessageConsole)console).getAttribute("org.eclipse.cft.server.CloudInstance");
                    if (server instanceof IServer && app instanceof CloudFoundryApplicationModule && index instanceof Integer) {
                        ApplicationLogConsoleManager.this.stopConsole((IServer)server, (CloudFoundryApplicationModule)app, (Integer)index);
                    }
                }
                ++n2;
            }
        }
    };

    public ApplicationLogConsoleManager() {
        this.consoleByUri = new HashMap<String, ApplicationLogConsole>();
        this.consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        this.consoleManager.addConsoleListener(this.listener);
    }

    @Override
    public void startConsole(CloudFoundryServer server, LogContentType type, CloudFoundryApplicationModule appModule, int instanceIndex, boolean show, boolean clear, IProgressMonitor monitor) {
        try {
            this.doStartConsole(server, type, appModule, show, clear);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
    }

    protected CloudFoundryConsole doStartConsole(CloudFoundryServer server, LogContentType type, CloudFoundryApplicationModule appModule, boolean show, boolean clear) throws CoreException {
        if (!appModule.isDeployed()) {
            throw CloudErrorUtil.toCoreException((String)NLS.bind((String)Messages.ApplicationLogConsoleManager_APPLICATION_NOT_PUBLISHED, (Object)appModule.getDeployedApplicationName()));
        }
        ApplicationLogConsole serverLogTail = this.getApplicationLogConsole(server, appModule);
        if (serverLogTail != null) {
            if (clear) {
                serverLogTail.getConsole().clearConsole();
            }
            serverLogTail.startTailing(type);
        }
        if (show && serverLogTail != null) {
            this.consoleManager.showConsoleView((IConsole)serverLogTail.getConsole());
        }
        return serverLogTail;
    }

    protected synchronized ApplicationLogConsole getApplicationLogConsole(CloudFoundryServer server, CloudFoundryApplicationModule appModule) {
        String appUrl = ApplicationLogConsoleManager.getConsoleId(server.getServer(), appModule);
        ApplicationLogConsole serverLogTail = this.consoleByUri.get(appUrl);
        if (serverLogTail == null) {
            MessageConsole appConsole = ApplicationLogConsoleManager.getApplicationConsole(server, appModule);
            serverLogTail = new ApplicationLogConsole(new ConsoleConfig(appConsole, server, appModule));
            this.consoleByUri.put(ApplicationLogConsoleManager.getConsoleId(server.getServer(), appModule), serverLogTail);
        }
        return serverLogTail;
    }

    @Override
    public MessageConsole findCloudFoundryConsole(IServer server, CloudFoundryApplicationModule appModule) {
        String curConsoleId = ApplicationLogConsoleManager.getConsoleId(server, appModule);
        if (curConsoleId != null && this.consoleByUri.get(curConsoleId) != null) {
            return this.consoleByUri.get(curConsoleId).getConsole();
        }
        return null;
    }

    @Override
    public void writeToStandardConsole(String message, CloudFoundryServer server, CloudFoundryApplicationModule appModule, int instanceIndex, boolean clear, boolean isError) {
        if (appModule == null) {
            return;
        }
        LogContentType type = isError ? StandardLogContentType.STD_ERROR : StandardLogContentType.STD_OUT;
        ApplicationLogConsole serverLogTail = this.getApplicationLogConsole(server, appModule);
        if (serverLogTail != null) {
            if (clear) {
                serverLogTail.getConsole().clearConsole();
            }
            this.doWriteToStdConsole(message, serverLogTail, type);
            this.consoleManager.showConsoleView((IConsole)serverLogTail.getConsole());
        }
    }

    protected void doWriteToStdConsole(String message, CloudFoundryConsole console, LogContentType type) {
        if (StandardLogContentType.STD_ERROR.equals((Object)type)) {
            console.writeToStdError(message);
        } else {
            console.writeToStdOut(message);
        }
    }

    @Override
    public void showCloudFoundryLogs(CloudFoundryServer server, CloudFoundryApplicationModule appModule, int instanceIndex, boolean clear, IProgressMonitor monitor) {
        CloudFoundryConsole console = null;
        try {
            console = this.doStartConsole(server, StandardLogContentType.APPLICATION_LOG, appModule, true, false);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError((Throwable)e);
            return;
        }
        if (console instanceof ApplicationLogConsole) {
            ApplicationLogConsole logConsole = (ApplicationLogConsole)console;
            CloudFoundryServerBehaviour behaviour = server.getBehaviour();
            try {
                List logs = behaviour.getRecentApplicationLogs(appModule.getDeployedApplicationName(), monitor);
                if (!logs.isEmpty()) {
                    logConsole.writeApplicationLogs(logs);
                } else {
                    this.doWriteToStdConsole(String.valueOf(org.eclipse.cft.server.core.internal.Messages.ApplicationLogConsoleManager_NO_RECENT_LOGS) + '\n', logConsole, StandardLogContentType.STD_OUT);
                }
            }
            catch (CoreException ce) {
                String message = NLS.bind((String)(String.valueOf(org.eclipse.cft.server.core.internal.Messages.ERROR_EXISTING_APPLICATION_LOGS) + '\n'), (Object)appModule.getDeployedApplicationName(), (Object)ce.getMessage());
                CloudFoundryPlugin.logError((String)message, (Throwable)ce);
                this.doWriteToStdConsole(message, logConsole, StandardLogContentType.STD_ERROR);
            }
        }
    }

    @Override
    public void stopConsole(IServer server, CloudFoundryApplicationModule appModule, int instanceIndex) {
        String appUrl = ApplicationLogConsoleManager.getConsoleId(server, appModule);
        CloudFoundryConsole serverLogTail = this.consoleByUri.get(appUrl);
        if (serverLogTail != null) {
            this.consoleByUri.remove(appUrl);
            serverLogTail.stop();
            MessageConsole messageConsole = serverLogTail.getConsole();
            this.consoleManager.removeConsoles(new IConsole[]{messageConsole});
            messageConsole.destroy();
        }
    }

    @Override
    public void stopConsoles() {
        for (Map.Entry<String, ApplicationLogConsole> tailEntry : this.consoleByUri.entrySet()) {
            tailEntry.getValue().stop();
        }
        this.consoleByUri.clear();
    }

    public static MessageConsole getApplicationConsole(CloudFoundryServer server, CloudFoundryApplicationModule appModule) {
        MessageConsole appConsole = null;
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console instanceof MessageConsole && console.getName().equals(ApplicationLogConsoleManager.getConsoleDisplayName(server, appModule))) {
                appConsole = (MessageConsole)console;
            }
            ++n2;
        }
        if (appConsole == null) {
            appConsole = new MessageConsole(ApplicationLogConsoleManager.getConsoleDisplayName(server, appModule), "org.eclipse.cft.server.appcloud", null, true);
            appConsole.setAttribute("org.eclipse.cft.server.Server", (Object)server);
            appConsole.setAttribute("org.eclipse.cft.server.CloudApp", (Object)appModule);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{appConsole});
        }
        return appConsole;
    }

    public static String getConsoleId(IServer server, CloudFoundryApplicationModule appModule) {
        return String.valueOf(server.getId()) + "/" + appModule.getDeployedApplicationName();
    }

    public static String getConsoleDisplayName(CloudFoundryServer server, CloudFoundryApplicationModule appModule) {
        StringWriter writer = new StringWriter();
        writer.append(server.getServer().getName());
        writer.append('-');
        CloudFoundrySpace space = server.getCloudFoundrySpace();
        if (space != null) {
            writer.append('-');
            writer.append(space.getOrgName());
            writer.append('-');
            writer.append('-');
            writer.append(space.getSpaceName());
            writer.append('-');
            writer.append('-');
        }
        writer.append(appModule.getDeployedApplicationName());
        return writer.toString();
    }
}

