/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.rse.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.rse.internal.AccountResource;
import org.eclipse.cft.server.rse.internal.ApplicationResource;
import org.eclipse.cft.server.rse.internal.CloudFoundryRsePlugin;
import org.eclipse.cft.server.rse.internal.FileResource;
import org.eclipse.cft.server.rse.internal.ICloudFoundryFileService;
import org.eclipse.cft.server.rse.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class CloudFoundryFileService
extends AbstractFileService
implements ICloudFoundryFileService {
    private List<AccountResource> accounts;
    private List<ApplicationResource> applications;
    private IHost host;

    public CloudFoundryFileService(IHost host) {
        this.host = host;
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
    }

    public void copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        return null;
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        return null;
    }

    public void delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
    }

    public void download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        Object[] array = this.parseNestedFiles(remoteParent);
        if (array != null) {
            ApplicationResource app = (ApplicationResource)array[0];
            String path = (String)array[1];
            CloudFoundryServer server = app.getServer();
            String appName = app.getCloudApplication().getName();
            int instance = app.getInstanceId();
            try {
                String content = server.getBehaviour().getFile(appName, instance, path.concat(remoteFile).substring(1), monitor);
                if (content != null) {
                    if (!localFile.exists()) {
                        localFile.getParentFile().mkdirs();
                    }
                    ByteArrayInputStream inStream = new ByteArrayInputStream(content.getBytes());
                    BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(localFile));
                    byte[] buffer = new byte[4096];
                    int bytesRead = -1;
                    while ((bytesRead = inStream.read(buffer)) != -1) {
                        ((OutputStream)outStream).write(buffer, 0, bytesRead);
                    }
                    ((OutputStream)outStream).flush();
                    inStream.close();
                    ((OutputStream)outStream).close();
                }
            }
            catch (Exception e) {
                CloudFoundryRsePlugin.logError((String)("An error occurred while opening file: " + remoteFile + " for application: " + appName), (Throwable)e);
            }
        }
    }

    public String getDescription() {
        return Messages.CloudFoundryFileService_DESCRIPTION_FILE_SERVICES;
    }

    public IHostFile getFile(String remoteParent, String name, IProgressMonitor monitor) throws SystemMessageException {
        String path;
        List<FileResource> files;
        AccountResource account = this.parseAccount((remoteParent = remoteParent.concat("/")).concat(name));
        if (account != null) {
            return account;
        }
        ApplicationResource app = this.parseApp(remoteParent.concat(name));
        if (app != null) {
            return app;
        }
        Object[] array = this.parseNestedFiles(remoteParent);
        if (array != null && (files = (app = (ApplicationResource)array[0]).getChildren(path = (String)array[1], monitor)) != null) {
            for (FileResource file : files) {
                if (!name.equals(file.getName())) continue;
                return file;
            }
        }
        return null;
    }

    public String getName() {
        return Messages.CloudFoundryFileService_DESCRIPTION_FILE_SERVICE_NAME;
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) throws SystemMessageException {
        ArrayList<AccountResource> list = new ArrayList<AccountResource>();
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            IServer candidate = allServers[i];
            if (CloudFoundryRsePlugin.doesServerBelongToHost(candidate, this.host)) {
                CloudFoundryServer server = (CloudFoundryServer)candidate.loadAdapter(CloudFoundryServer.class, monitor);
                AccountResource resource = new AccountResource(server);
                list.add(resource);
            }
            ++i;
        }
        this.accounts = list;
        return this.accounts.toArray(new AccountResource[this.accounts.size()]);
    }

    public IHostFile getUserHome() {
        return null;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
    }

    public void rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) throws SystemMessageException {
    }

    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
    }

    public void setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
    }

    public void setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
    }

    public void upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
    }

    public void upload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
    }

    private AccountResource parseAccount(String path) {
        int index = path.lastIndexOf("@");
        if (index >= 0 && index + 1 <= path.length()) {
            String accountName = path.substring(0, index);
            String accountUrl = path.substring(index + 1);
            for (AccountResource account : this.accounts) {
                CloudFoundryServer server = account.getServer();
                if (!accountUrl.equals(server.getUrl()) || !accountName.equals(server.getServer().getName())) continue;
                return account;
            }
        }
        return null;
    }

    private ApplicationResource parseApp(String path) {
        int index = path.indexOf("/");
        if (index >= 0 && index + 1 <= path.length()) {
            String appUrl = path.substring(0, index);
            String instance = path.substring(index + 1);
            for (ApplicationResource app : this.applications) {
                String cloudAppId;
                CloudApplication cloudApp = app.getCloudApplication();
                if (!this.validApp(appUrl, cloudApp, cloudAppId = Integer.valueOf(app.getInstanceId()).toString(), instance)) continue;
                return app;
            }
        }
        return null;
    }

    protected boolean validApp(String appUrl, CloudApplication cloudApp, String cloudAppId, String instance) {
        List uris = cloudApp.getUris();
        boolean matchingUri = false;
        if (appUrl != null && appUrl.length() > 0) {
            boolean bl = matchingUri = uris != null && !uris.isEmpty() && appUrl.equals(uris.get(0)) || appUrl.equals(cloudApp.getName());
        }
        return matchingUri && instance.equals(cloudAppId);
    }

    private Object[] parseNestedFiles(String path) {
        int index = path.indexOf("/");
        if (index >= 0 && index + 1 <= path.length()) {
            String appUrl = path.substring(0, index);
            String leftover = path.substring(index + 1);
            if ((index = leftover.indexOf("/")) >= 0) {
                String instance = leftover.substring(0, index);
                String filePath = leftover.substring(index);
                for (ApplicationResource app : this.applications) {
                    String cloudAppId;
                    CloudApplication cloudApp = app.getCloudApplication();
                    if (!this.validApp(appUrl, cloudApp, cloudAppId = Integer.valueOf(app.getInstanceId()).toString(), instance)) continue;
                    return new Object[]{app, filePath};
                }
            }
        }
        return null;
    }

    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        AccountResource account = this.parseAccount(parentPath);
        if (account != null) {
            this.applications = account.fetchChildren(monitor);
            return this.applications.toArray(new ApplicationResource[this.applications.size()]);
        }
        ApplicationResource app = this.parseApp(parentPath);
        if (app != null) {
            List<FileResource> files = app.fetchChildren("/", monitor);
            return files.toArray(new FileResource[files.size()]);
        }
        Object[] array = this.parseNestedFiles(parentPath);
        if (array != null) {
            app = (ApplicationResource)array[0];
            String path = (String)array[1];
            List<FileResource> files = app.fetchChildren(path, monitor);
            return files.toArray(new FileResource[files.size()]);
        }
        return null;
    }
}

