/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryConstants;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryClientFactory;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudFoundryURLNavigation;
import org.eclipse.cft.server.ui.internal.IPartChangeListener;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.cft.server.ui.internal.editor.CloudUrlWidget;
import org.eclipse.cft.server.ui.internal.wizards.WizardHandleContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class CloudFoundryCredentialsPart
extends UIPart
implements IPartChangeListener {
    private CloudFoundryServer cfServer;
    private Text emailText;
    private TabFolder folder;
    private Text passwordText;
    private String serverTypeId;
    private String service;
    private CloudUrlWidget urlWidget;
    private Button validateButton;
    private Button cfSignupButton;
    private IRunnableContext runnableContext;
    private Button sso;
    private PageBook pageBook;
    private Link prompt;
    private Label passcodeLabel;
    private Text passcodeText;

    public CloudFoundryCredentialsPart(CloudFoundryServer cfServer, WizardPage wizardPage) {
        this(cfServer);
        if (wizardPage != null) {
            wizardPage.setTitle(NLS.bind((String)Messages.CloudFoundryCredentialsPart_TEXT_CREDENTIAL_WIZ_TITLE, (Object)this.service));
            wizardPage.setDescription(Messages.SERVER_WIZARD_VALIDATOR_CLICK_TO_VALIDATE);
            ImageDescriptor banner = CloudFoundryImages.getWizardBanner(this.serverTypeId);
            if (banner != null) {
                wizardPage.setImageDescriptor(banner);
            }
            this.runnableContext = wizardPage.getWizard() != null && wizardPage.getWizard().getContainer() != null ? wizardPage.getWizard().getContainer() : null;
        }
    }

    public CloudFoundryCredentialsPart(CloudFoundryServer cfServer, WizardHandleContext context) {
        this(cfServer);
        IWizardHandle wizardHandle = context.getWizardHandle();
        if (wizardHandle != null) {
            wizardHandle.setTitle(NLS.bind((String)Messages.CloudFoundryCredentialsPart_TEXT_CREDENTIAL_WIZ_TITLE, (Object)this.service));
            wizardHandle.setDescription(Messages.SERVER_WIZARD_VALIDATOR_CLICK_TO_VALIDATE);
            ImageDescriptor banner = CloudFoundryImages.getWizardBanner(this.serverTypeId);
            if (banner != null) {
                wizardHandle.setImageDescriptor(banner);
            }
            this.runnableContext = context.getRunnableContext();
        }
    }

    public CloudFoundryCredentialsPart(CloudFoundryServer cfServer) {
        this.cfServer = cfServer;
        this.serverTypeId = cfServer.getServer().getServerType().getId();
        this.service = CloudFoundryBrandingExtensionPoint.getServiceName((String)this.serverTypeId);
        this.runnableContext = PlatformUI.getWorkbench().getProgressService();
    }

    @Override
    public Control createPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.folder = new TabFolder(composite, 0);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        });
        try {
            this.createExistingUserComposite(this.folder);
            this.updateUI(false);
        }
        catch (Throwable e1) {
            CloudFoundryPlugin.logError((Throwable)e1);
        }
        return composite;
    }

    public void setServer(CloudFoundryServer server) {
        this.cfServer = server;
    }

    private void createExistingUserComposite(TabFolder folder) throws CoreException {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sso = new Button(composite, 32);
        GridData gd = new GridData(4, 4, true, false);
        this.sso.setLayoutData((Object)gd);
        this.sso.setText(Messages.SSO_SERVER);
        this.sso.setSelection(this.cfServer.isSso());
        this.pageBook = new PageBook(composite, 0);
        gd = new GridData(4, 4, true, false);
        this.pageBook.setLayoutData((Object)gd);
        final Control emailPasswordControl = this.createEmailPasswordControl((Composite)this.pageBook);
        final Control passcodeControl = this.createPasscodeControl((Composite)this.pageBook);
        this.showPage(emailPasswordControl, passcodeControl);
        this.sso.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudFoundryCredentialsPart.this.cfServer.setSso(CloudFoundryCredentialsPart.this.sso.getSelection());
                if (CloudFoundryCredentialsPart.this.sso.getSelection()) {
                    CloudFoundryCredentialsPart.this.updatePromptTextWithSsoUrl();
                }
                CloudFoundryCredentialsPart.this.showPage(emailPasswordControl, passcodeControl);
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        });
        this.urlWidget = new CloudUrlWidget(this.cfServer){

            @Override
            protected void setUpdatedSelectionInServer() {
                super.setUpdatedSelectionInServer();
                if (CloudFoundryCredentialsPart.this.sso.getSelection()) {
                    CloudFoundryCredentialsPart.this.updatePromptTextWithSsoUrl();
                }
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        };
        this.urlWidget.createControls(composite, this.runnableContext);
        String url = this.urlWidget.getURLSelection();
        if (url != null) {
            this.cfServer.setUrl(CFUiUtil.getUrlFromDisplayText(url));
        }
        Composite validateComposite = new Composite(composite, 0);
        validateComposite.setLayout((Layout)new GridLayout(3, false));
        validateComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.validateButton = new Button(validateComposite, 8);
        this.validateButton.setText(Messages.CloudFoundryCredentialsPart_TEXT_VALIDATE_BUTTON);
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CloudFoundryCredentialsPart.this.updateUI(true);
            }
        });
        this.cfSignupButton = new Button(validateComposite, 8);
        this.cfSignupButton.setText(CloudFoundryConstants.PUBLIC_CF_SERVER_SIGNUP_LABEL);
        this.cfSignupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String signupURL = CloudFoundryBrandingExtensionPoint.getSignupURL((String)CloudFoundryCredentialsPart.this.serverTypeId, (String)CloudFoundryCredentialsPart.this.cfServer.getUrl());
                if (signupURL != null) {
                    CloudFoundryURLNavigation nav = new CloudFoundryURLNavigation(signupURL);
                    nav.navigateExternal();
                }
            }
        });
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.COMMONTXT_ACCOUNT_INFO);
        item.setControl((Control)composite);
    }

    private void showPage(Control emailPasswordControl, Control passcodeControl) {
        if (this.sso.getSelection()) {
            this.pageBook.showPage(passcodeControl);
        } else {
            this.pageBook.showPage(emailPasswordControl);
        }
    }

    private Control createPasscodeControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.prompt = new Link(composite, 16448);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.prompt.setLayoutData((Object)gd);
        this.prompt.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CloudFoundryCredentialsPart.this.cfServer.getUrl() != null && !CloudFoundryCredentialsPart.this.cfServer.getUrl().isEmpty()) {
                    try {
                        String url = CloudFoundryClientFactory.getSsoUrl((String)CloudFoundryCredentialsPart.this.cfServer.getUrl(), (boolean)CloudFoundryCredentialsPart.this.cfServer.isSelfSigned());
                        if (url != null && !url.isEmpty()) {
                            CFUiUtil.openUrl(url, 1);
                        }
                    }
                    catch (Exception e) {
                        CloudFoundryServerUiPlugin.logError(e);
                    }
                }
            }
        });
        this.passcodeLabel = new Label(composite, 0);
        this.passcodeLabel.setText(Messages.LABEL_PASSCODE);
        this.passcodeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.passcodeText = new Text(composite, 0x400800);
        this.passcodeText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.passcodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudFoundryCredentialsPart.this.cfServer.setPasscode(CloudFoundryCredentialsPart.this.passcodeText.getText());
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        });
        return composite;
    }

    private void updatePromptTextWithSsoUrl() {
        CFUiUtil.runOnUIThreadUntilTimeout(Messages.CFCredentialsPart_ACQUIRING_SSO_URL, new Runnable(){

            @Override
            public void run() {
                final String ssoPromptText = CFUiUtil.getPromptText(CloudFoundryCredentialsPart.this.cfServer);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CloudFoundryCredentialsPart.this.prompt.setText(ssoPromptText);
                    }
                });
            }
        });
    }

    private Control createEmailPasswordControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label emailLabel = new Label(composite, 0);
        emailLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        emailLabel.setText(Messages.COMMONTXT_EMAIL_WITH_COLON);
        this.emailText = new Text(composite, 2048);
        this.emailText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.emailText.setEditable(true);
        this.emailText.setFocus();
        if (this.cfServer.getUsername() != null) {
            this.emailText.setText(this.cfServer.getUsername());
        }
        this.emailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudFoundryCredentialsPart.this.cfServer.setUsername(CloudFoundryCredentialsPart.this.emailText.getText());
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        });
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        passwordLabel.setText(Messages.COMMONTXT_PW);
        this.passwordText = new Text(composite, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.passwordText.setEditable(true);
        if (this.cfServer.getPassword() != null) {
            this.passwordText.setText(this.cfServer.getPassword());
        }
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudFoundryCredentialsPart.this.cfServer.setPassword(CloudFoundryCredentialsPart.this.passwordText.getText());
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        });
        return composite;
    }

    public void updateUI(boolean validateAgainstServer) {
        int eventType = validateAgainstServer ? 1002 : 1000;
        this.notifyChange(new PartChangeEvent(this.runnableContext, Status.OK_STATUS, this, eventType));
        this.updateButtons();
    }

    protected void updateButtons() {
        String url = this.cfServer.getUrl();
        this.cfSignupButton.setEnabled(!this.sso.getSelection() && CloudFoundryURLNavigation.canEnableCloudFoundryNavigation(this.serverTypeId, url));
    }

    @Override
    public void handleChange(PartChangeEvent event) {
        if (event == null) {
            return;
        }
        int type = event.getType();
        boolean valuesFilled = (type == 1003 || type == 1001) && event.getStatus() != null && event.getStatus().isOK();
        this.validateButton.setEnabled(valuesFilled && !this.sso.getSelection());
    }
}

