/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cft.server.core.internal.ProviderPriority;
import org.eclipse.cft.server.core.internal.client.CFClientProvider;
import org.eclipse.cft.server.core.internal.client.CloudInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class CFClientProviderRegistry {
    public static final String EXTENSION_POINT = "org.eclipse.cft.server.core.client";
    public static final String PROVIDER_ELEMENT = "clientProvider";
    public static final String CLASS_ATTR = "class";
    private Map<ProviderPriority, List<CFClientProvider>> providersPerPriority = null;
    public static final CFClientProviderRegistry INSTANCE = new CFClientProviderRegistry();

    private CFClientProviderRegistry() {
    }

    public synchronized void load() throws CoreException {
        if (this.providersPerPriority == null) {
            this.providersPerPriority = new HashMap<ProviderPriority, List<CFClientProvider>>();
            IExtensionPoint extnPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
            if (extnPoint != null) {
                IExtension[] iExtensionArray = extnPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CFClientProvider provider;
                        IConfigurationElement config = iConfigurationElementArray[n4];
                        if (PROVIDER_ELEMENT.equals(config.getName()) && (provider = (CFClientProvider)config.createExecutableExtension(CLASS_ATTR)) != null) {
                            List<CFClientProvider> prvlist = this.providersPerPriority.get((Object)provider.getPriority());
                            if (prvlist == null) {
                                prvlist = new ArrayList<CFClientProvider>();
                                this.providersPerPriority.put(provider.getPriority(), prvlist);
                            }
                            if (!prvlist.contains(provider)) {
                                prvlist.add(provider);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    public CFClientProvider getClientProvider(String serverUrl, CloudInfo info) throws CoreException {
        this.load();
        if (serverUrl != null) {
            ProviderPriority[] providerPriorityArray = ProviderPriority.values();
            int n = providerPriorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProviderPriority priority = providerPriorityArray[n2];
                List<CFClientProvider> providers = this.providersPerPriority.get((Object)priority);
                if (providers != null) {
                    for (CFClientProvider prvd : providers) {
                        if (!prvd.supports(serverUrl, info)) continue;
                        return prvd;
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

