/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.ICloudFoundryUrlProvider;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class CloudFoundryBrandingExtensionPoint {
    public static String ELEM_DEFAULT_URL = "defaultUrl";
    public static String ELEM_CLOUD_URL = "cloudUrl";
    public static String ELEM_WILDCARD = "wildcard";
    public static String ATTR_REMOTE_SYSTEM_TYPE_ID = "remoteSystemTypeId";
    public static String ATTR_SERVER_DISPLAY_NAME = "serverDisplayName";
    public static String ATTR_SERVER_TYPE_ID = "serverTypeId";
    public static String ATTR_NAME = "name";
    public static String ATTR_URL = "url";
    public static String ATTR_PROVIDE_SERVICES = "provideServices";
    public static String ATTR_WIZ_BAN = "wizardBanner";
    public static String ELEM_SERVICE = "service";
    public static String ATTR_SIGNUP_URL = "signupURL";
    public static String ATTR_URL_PROVIDER_CLASS = "urlProviderClass";
    public static String ATTR_SUPPORT_UPPER_CASE_URL = "supportUpperCaseURL";
    public static String POINT_ID = "org.eclipse.cft.server.core.branding";
    private static Map<String, IConfigurationElement> brandingDefinitions = new HashMap<String, IConfigurationElement>();
    private static Map<String, ICloudFoundryUrlProvider> urlProviders = new HashMap<String, ICloudFoundryUrlProvider>();
    private static List<String> brandingServerTypeIds = new ArrayList<String>();
    private static boolean read;

    public static IConfigurationElement getConfigurationElement(String serverTypeId) {
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        return brandingDefinitions.get(serverTypeId);
    }

    private static List<AbstractCloudFoundryUrl> getStaticUrlsFromExtension(String serverTypeId, String elementType) {
        IConfigurationElement config;
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        if ((config = brandingDefinitions.get(serverTypeId)) != null) {
            IConfigurationElement[] defaultUrls;
            ArrayList<AbstractCloudFoundryUrl> result = new ArrayList<AbstractCloudFoundryUrl>();
            IConfigurationElement[] iConfigurationElementArray = defaultUrls = config.getChildren(elementType);
            int n = defaultUrls.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement defaultUrl = iConfigurationElementArray[n2];
                String urlName = defaultUrl.getAttribute(ATTR_NAME);
                String url = defaultUrl.getAttribute(ATTR_URL);
                if (urlName != null && urlName.length() > 0 && url != null && url.length() > 0) {
                    IConfigurationElement[] _wildcards;
                    String signupURL = defaultUrl.getAttribute(ATTR_SIGNUP_URL);
                    ArrayList<AbstractCloudFoundryUrl.Wildcard> wildcards = new ArrayList<AbstractCloudFoundryUrl.Wildcard>();
                    IConfigurationElement[] iConfigurationElementArray2 = _wildcards = defaultUrl.getChildren(ELEM_WILDCARD);
                    int n3 = _wildcards.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement wildcard = iConfigurationElementArray2[n4];
                        String wildcardName = wildcard.getAttribute(ATTR_NAME);
                        wildcards.add(new AbstractCloudFoundryUrl.Wildcard(wildcardName));
                        ++n4;
                    }
                    result.add(new AbstractCloudFoundryUrl(urlName, url, wildcards, signupURL){});
                }
                ++n2;
            }
            return result;
        }
        return null;
    }

    private static ICloudFoundryUrlProvider getCloudFoundryUrlProvider(String serverTypeId) {
        ICloudFoundryUrlProvider provider;
        block9: {
            String urlProviderClass = null;
            provider = urlProviders.get(serverTypeId);
            if (provider == null) {
                try {
                    IConfigurationElement config = brandingDefinitions.get(serverTypeId);
                    if (config != null) {
                        urlProviderClass = config.getAttribute(ATTR_URL_PROVIDER_CLASS);
                        if (urlProviderClass != null && !urlProviderClass.isEmpty()) {
                            Object providerObject = config.createExecutableExtension(ATTR_URL_PROVIDER_CLASS);
                            provider = (ICloudFoundryUrlProvider)providerObject;
                            urlProviders.put(serverTypeId, provider);
                        } else {
                            urlProviders.put(serverTypeId, NoCloudFoundryUrlProvider.getInstance());
                        }
                        break block9;
                    }
                    urlProviders.put(serverTypeId, NoCloudFoundryUrlProvider.getInstance());
                }
                catch (CoreException coreException) {
                    urlProviders.put(serverTypeId, NoCloudFoundryUrlProvider.getInstance());
                    CloudFoundryPlugin.logError("Unable to instantiate " + urlProviderClass);
                }
                catch (ClassCastException classCastException) {
                    urlProviders.put(serverTypeId, NoCloudFoundryUrlProvider.getInstance());
                    CloudFoundryPlugin.logError(String.valueOf(urlProviderClass) + " must implement ICloudFoundryUrlProvider");
                }
            } else if (provider.equals(NoCloudFoundryUrlProvider.getInstance())) {
                provider = null;
            }
        }
        return provider;
    }

    private static List<AbstractCloudFoundryUrl> getNonDefaultCloudFoundryUrlsFromProvider(String serverTypeId) {
        List<AbstractCloudFoundryUrl> cloudUrls;
        ArrayList<AbstractCloudFoundryUrl> result = null;
        ICloudFoundryUrlProvider provider = CloudFoundryBrandingExtensionPoint.getCloudFoundryUrlProvider(serverTypeId);
        if (provider != null && (cloudUrls = provider.getNonDefaultUrls()) != null) {
            result = new ArrayList<AbstractCloudFoundryUrl>();
            for (AbstractCloudFoundryUrl cloudUrl : cloudUrls) {
                result.add(cloudUrl);
            }
        }
        return result;
    }

    private static AbstractCloudFoundryUrl getDefaultCloudFoundryUrlFromProvider(String serverTypeId) {
        AbstractCloudFoundryUrl defaultUrl = null;
        ICloudFoundryUrlProvider provider = CloudFoundryBrandingExtensionPoint.getCloudFoundryUrlProvider(serverTypeId);
        if (provider != null) {
            defaultUrl = provider.getDefaultUrl();
        }
        return defaultUrl;
    }

    public static List<AbstractCloudFoundryUrl> getCloudUrls(String serverTypeId) {
        List<AbstractCloudFoundryUrl> cloudUrls;
        List<AbstractCloudFoundryUrl> contributorCloudUrls;
        List<AbstractCloudFoundryUrl> defaultUrls;
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        AbstractCloudFoundryUrl contributorDefaultUrl = CloudFoundryBrandingExtensionPoint.getDefaultCloudFoundryUrlFromProvider(serverTypeId);
        ArrayList<AbstractCloudFoundryUrl> urls = new ArrayList<AbstractCloudFoundryUrl>();
        if (contributorDefaultUrl != null && (defaultUrls = CloudFoundryBrandingExtensionPoint.getStaticUrlsFromExtension(serverTypeId, ELEM_DEFAULT_URL)) != null && defaultUrls.size() == 1) {
            urls.addAll(defaultUrls);
        }
        if ((contributorCloudUrls = CloudFoundryBrandingExtensionPoint.getNonDefaultCloudFoundryUrlsFromProvider(serverTypeId)) != null) {
            urls.addAll(contributorCloudUrls);
        }
        if ((cloudUrls = CloudFoundryBrandingExtensionPoint.getStaticUrlsFromExtension(serverTypeId, ELEM_CLOUD_URL)) != null) {
            urls.addAll(cloudUrls);
        }
        if (urls.size() != 0) {
            return urls;
        }
        return null;
    }

    public static AbstractCloudFoundryUrl getDefaultUrl(String serverTypeId) {
        AbstractCloudFoundryUrl providerDefaultUrl;
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        if ((providerDefaultUrl = CloudFoundryBrandingExtensionPoint.getDefaultCloudFoundryUrlFromProvider(serverTypeId)) != null) {
            return providerDefaultUrl;
        }
        List<AbstractCloudFoundryUrl> urls = CloudFoundryBrandingExtensionPoint.getStaticUrlsFromExtension(serverTypeId, ELEM_DEFAULT_URL);
        if (urls != null && urls.size() == 1) {
            return urls.get(0);
        }
        return null;
    }

    public static String getRemoteSystemTypeId(String serverTypeId) {
        IConfigurationElement config;
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        if ((config = brandingDefinitions.get(serverTypeId)) != null) {
            return config.getAttribute(ATTR_REMOTE_SYSTEM_TYPE_ID);
        }
        return null;
    }

    public static String getServerDisplayName(String serverTypeId) {
        IConfigurationElement config;
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        if ((config = brandingDefinitions.get(serverTypeId)) != null) {
            return config.getAttribute(ATTR_SERVER_DISPLAY_NAME);
        }
        return null;
    }

    public static String getServiceName(String serverTypeId) {
        IConfigurationElement config;
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        if ((config = brandingDefinitions.get(serverTypeId)) != null) {
            return config.getAttribute(ATTR_NAME);
        }
        return null;
    }

    public static boolean getProvideServices(String serverTypeId) {
        IConfigurationElement config;
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        if ((config = brandingDefinitions.get(serverTypeId)) != null) {
            return Boolean.valueOf(config.getAttribute(ATTR_PROVIDE_SERVICES));
        }
        return false;
    }

    public static List<String> getServerTypeIds() {
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        return brandingServerTypeIds;
    }

    protected static void readBrandingDefinitions() {
        IExtensionPoint brandingExtPoint = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        if (brandingExtPoint != null) {
            brandingServerTypeIds.clear();
            IExtension[] iExtensionArray = brandingExtPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String serverId = config.getAttribute(ATTR_SERVER_TYPE_ID);
                    String name = config.getAttribute(ATTR_NAME);
                    if (serverId != null && serverId.trim().length() > 0 && name != null && name.trim().length() > 0) {
                        brandingDefinitions.put(serverId, config);
                        brandingServerTypeIds.add(serverId);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        read = true;
    }

    public static boolean isSupportUpperCaseURL(String serverTypeId) {
        IConfigurationElement config;
        if (!read) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
        }
        if ((config = brandingDefinitions.get(serverTypeId)) != null) {
            String isSupportUpperCaseURL = config.getAttribute(ATTR_SUPPORT_UPPER_CASE_URL);
            return isSupportUpperCaseURL == null ? true : Boolean.valueOf(isSupportUpperCaseURL);
        }
        return true;
    }

    public static String getSignupURL(String serverTypeId, String url) {
        if (url != null) {
            AbstractCloudFoundryUrl defaultUrl = CloudFoundryBrandingExtensionPoint.getDefaultUrl(serverTypeId);
            if (defaultUrl != null && defaultUrl.getUrl() != null && defaultUrl.getUrl().equals(url)) {
                return defaultUrl.getSignUpUrl();
            }
            List<AbstractCloudFoundryUrl> cloudUrls = CloudFoundryBrandingExtensionPoint.getCloudUrls(serverTypeId);
            if (cloudUrls != null) {
                for (AbstractCloudFoundryUrl aUrl : cloudUrls) {
                    if (!aUrl.getUrl().equals(url)) continue;
                    return aUrl.getSignUpUrl();
                }
            }
        }
        return null;
    }

    public static class CloudServerURL
    extends AbstractCloudFoundryUrl {
        private final boolean userDefined;
        private final boolean selfSigned;

        public CloudServerURL(String name, String url, boolean userDefined) {
            this(name, url, userDefined, null, false);
        }

        public CloudServerURL(String name, String url, boolean userDefined, String signupURL) {
            this(name, url, userDefined, signupURL, false);
        }

        public CloudServerURL(String name, String url, boolean userDefined, boolean selfSigned) {
            this(name, url, userDefined, null, selfSigned);
        }

        public CloudServerURL(String name, String url, boolean userDefined, String signUpURL, boolean selfSigned) {
            super(name, url, null, signUpURL);
            this.userDefined = userDefined;
            this.signUpUrl = signUpURL;
            this.selfSigned = selfSigned;
        }

        @Override
        public boolean getUserDefined() {
            return this.userDefined;
        }

        @Override
        public boolean getSelfSigned() {
            return this.selfSigned;
        }
    }

    private static class NoCloudFoundryUrlProvider
    implements ICloudFoundryUrlProvider {
        private static NoCloudFoundryUrlProvider instance;

        private NoCloudFoundryUrlProvider() {
        }

        public static ICloudFoundryUrlProvider getInstance() {
            if (instance == null) {
                instance = new NoCloudFoundryUrlProvider();
            }
            return instance;
        }

        @Override
        public AbstractCloudFoundryUrl getDefaultUrl() {
            return null;
        }

        @Override
        public List<AbstractCloudFoundryUrl> getNonDefaultUrls() {
            return null;
        }
    }
}

