/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDescriptor;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardRegistry;
import org.eclipse.cft.server.ui.internal.wizards.HostnameValidationResult;
import org.eclipse.cft.server.ui.internal.wizards.IApplicationWizardDelegate;
import org.eclipse.cft.server.ui.internal.wizards.IReservedURLTracker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.server.core.IModule;

public class CloudFoundryApplicationWizard
extends Wizard
implements IReservedURLTracker {
    protected final CloudFoundryApplicationModule module;
    protected final CloudFoundryServer server;
    protected IApplicationWizardDelegate wizardDelegate;
    protected final ApplicationWizardDescriptor applicationDescriptor;
    protected DeploymentInfoWorkingCopy workingCopy;
    private List<ReservedURL> reservedUrls;

    public CloudFoundryApplicationWizard(CloudFoundryServer server, CloudFoundryApplicationModule module, DeploymentInfoWorkingCopy workingCopy, IApplicationWizardDelegate wizardDelegate) {
        Assert.isNotNull((Object)server);
        Assert.isNotNull((Object)module);
        Assert.isNotNull((Object)workingCopy);
        this.server = server;
        this.module = module;
        this.wizardDelegate = wizardDelegate;
        this.workingCopy = workingCopy;
        this.applicationDescriptor = new ApplicationWizardDescriptor((ApplicationDeploymentInfo)this.workingCopy);
        this.applicationDescriptor.setApplicationStartMode(ApplicationAction.START);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.CloudFoundryApplicationWizard_TITLE_APP);
        this.reservedUrls = new ArrayList<ReservedURL>();
    }

    public void addPages() {
        List<IWizardPage> applicationDeploymentPages = null;
        if (this.wizardDelegate == null) {
            this.wizardDelegate = ApplicationWizardRegistry.getDefaultJavaWebWizardDelegate();
        }
        if ((applicationDeploymentPages = this.wizardDelegate.getWizardPages(this.applicationDescriptor, this.server.getServer(), (IModule)this.module)) != null && !applicationDeploymentPages.isEmpty()) {
            for (IWizardPage updatedPage : applicationDeploymentPages) {
                this.addPage(updatedPage);
            }
        } else {
            String moduleID = this.module != null && this.module.getModuleType() != null ? this.module.getModuleType().getId() : "Unknown module type.";
            CloudFoundryPlugin.logError((String)("No application deployment wizard pages found for application type: " + moduleID + ". Unable to complete application deployment. Check that the application type is registered in the Cloud Foundry application framework."));
        }
    }

    public List<CFServiceInstance> getCloudServicesToCreate() {
        return this.applicationDescriptor.getCloudServicesToCreate();
    }

    public boolean persistManifestChanges() {
        return this.applicationDescriptor.shouldPersistDeploymentInfo();
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        if (this.applicationDescriptor.getApplicationStartMode() != null) {
            return new DeploymentConfiguration(this.applicationDescriptor.getApplicationStartMode());
        }
        return null;
    }

    private List<CloudApplicationURL> getCreatedUrls() {
        ArrayList<CloudApplicationURL> urlsToDelete = new ArrayList<CloudApplicationURL>();
        for (ReservedURL url : this.reservedUrls) {
            if (!url.isRouteCreated() || url.getUrl() == null) continue;
            urlsToDelete.add(url.getUrl());
        }
        return urlsToDelete;
    }

    public boolean performFinish() {
        this.workingCopy.save();
        CFUiUtil.cleanupReservedRoutesIfNotNeeded(this.workingCopy, (IWizard)this, this.server, this.getCreatedUrls());
        return true;
    }

    public boolean performCancel() {
        CFUiUtil.cleanupReservedRoutes((IWizard)this, this.server, this.getCreatedUrls(), null);
        return super.performCancel();
    }

    @Override
    public void addToReserved(CloudApplicationURL appUrl, boolean isUrlCreatedByWizard) {
        this.reservedUrls.add(new ReservedURL(appUrl, isUrlCreatedByWizard));
    }

    @Override
    public void removeFromReserved(CloudApplicationURL appUrl) {
        if (this.reservedUrls.contains(appUrl)) {
            this.reservedUrls.remove(appUrl);
        }
    }

    @Override
    public boolean isReserved(CloudApplicationURL appUrl) {
        return this.reservedUrls.contains(appUrl);
    }

    @Override
    public HostnameValidationResult validateURL(CloudApplicationURL appUrl) {
        return CFUiUtil.validateHostname(appUrl, this.server, this.getContainer());
    }

    private static class ReservedURL {
        private final CloudApplicationURL url;
        private final boolean isRouteCreated;

        public ReservedURL(CloudApplicationURL url, boolean isRouteCreated) {
            this.url = url;
            this.isRouteCreated = isRouteCreated;
        }

        public CloudApplicationURL getUrl() {
            return this.url;
        }

        public boolean isRouteCreated() {
            return this.isRouteCreated;
        }
    }
}

