/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

public class DebugConnectionDescriptor {
    private final String host;
    private final int port;
    private final int timeout;
    public static final int DEFAULT_TIMEOUT = 30000;

    public DebugConnectionDescriptor(String host, int port) {
        this(host, port, 30000);
    }

    public DebugConnectionDescriptor(String ip, int port, int timeout) {
        this.host = ip;
        this.port = port;
        this.timeout = timeout;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isValid() {
        return this.host != null && this.host.length() > 0 && this.port > 0;
    }

    public String toString() {
        return "DebugConnectionDescriptor [ip=" + this.host + ", port=" + this.port + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DebugConnectionDescriptor other = (DebugConnectionDescriptor)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.timeout == other.timeout;
    }
}

